/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client;

import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Map;
import net.goo.brutality.Brutality;
import net.goo.brutality.client.player_animation.AnimationHelper;
import net.goo.brutality.entity.spells.brimwielder.ExtinctionEntity;
import net.goo.brutality.event.LivingDodgeEvent;
import net.goo.brutality.item.base.BrutalityAnkletItem;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.item.weapon.throwing.VampireKnives;
import net.goo.brutality.network.ClientboundDodgePacket;
import net.goo.brutality.network.ClientboundParticlePacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundHandleThrowingProjectilePacket;
import net.goo.brutality.network.ServerboundPlayerAnimationPacket;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.sounds.ExtinctionSpellSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientAccess {
    private static ExtinctionSpellSoundInstance sound;

    public static void syncCapabilities(int entityId, Map<String, CompoundTag> data) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        for (Map.Entry<String, CompoundTag> entry : data.entrySet()) {
            String key = entry.getKey();
            CompoundTag tag = entry.getValue();
            Capability<? extends INBTSerializable<CompoundTag>> cap = BrutalityCapabilities.CapabilitySyncRegistry.get(key);
            if (cap == null) continue;
            entity.getCapability(cap).ifPresent(inst -> ((INBTSerializable)inst).deserializeNBT((Tag)tag));
        }
    }

    public static void playExtinctionSpellSound(ExtinctionEntity extinctionEntity) {
        ExtinctionSpellSoundInstance sound;
        ClientAccess.sound = sound = new ExtinctionSpellSoundInstance(extinctionEntity);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    public static void stopExtinctionSpellSound() {
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound);
    }

    public static void syncItemCooldowns(Map<Item, ItemCooldowns.CooldownInstance> cooldowns, int tickCount) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemCooldowns newCooldowns = player.m_36335_();
            newCooldowns.f_41515_.clear();
            newCooldowns.f_41515_.putAll(cooldowns);
            newCooldowns.f_41516_ = tickCount;
        }
    }

    public static void spawnParticles(ClientboundParticlePacket packet) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (int i = 0; i < packet.count; ++i) {
            float xOffset = (float)(level.f_46441_.m_188583_() * (double)packet.xDist);
            float yOffset = (float)(level.f_46441_.m_188583_() * (double)packet.yDist);
            float zOffset = (float)(level.f_46441_.m_188583_() * (double)packet.zDist);
            try {
                level.m_6493_(packet.particle, packet.overrideLimiter, (double)(packet.x + xOffset), (double)(packet.y + yOffset), (double)(packet.z + zOffset), (double)packet.xSpeed, (double)packet.ySpeed, (double)packet.zSpeed);
                continue;
            }
            catch (Throwable throwable) {
                Brutality.LOGGER.warn("Could not spawn particle effect {}: {}", (Object)packet.particle, (Object)throwable.getMessage());
                return;
            }
        }
    }

    public static void handleDodgeClient(ClientboundDodgePacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Holder.Reference damageType = level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)packet.damageTypeId));
        Entity directEntity = packet.hasDirectEntity && packet.directEntityId != null ? level.m_6815_(packet.directEntityId.intValue()) : null;
        Entity causingEntity = packet.hasCausingEntity && packet.causingEntityId != null ? level.m_6815_(packet.causingEntityId.intValue()) : null;
        DamageSource source = new DamageSource((Holder)damageType, directEntity, causingEntity);
        Entity entity = level.m_6815_(packet.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingDodgeEvent.Client client = new LivingDodgeEvent.Client(livingEntity, source, packet.amount);
            MinecraftForge.EVENT_BUS.post((Event)client);
            Item item = packet.anklet.m_41720_();
            if (item instanceof BrutalityAnkletItem) {
                BrutalityAnkletItem ankletItem = (BrutalityAnkletItem)item;
                ankletItem.onDodgeClient(livingEntity, source, packet.amount, packet.anklet);
            }
        }
    }

    public static class ThrowableWeaponHelper {
        private static final Object attributesLock = new Object();

        public static boolean handleCooldown(Player player, BrutalityThrowingItem item) {
            if (player.m_36335_().m_41519_((Item)item)) {
                return false;
            }
            if (item instanceof VampireKnives) {
                player.m_36335_().m_41524_((Item)item, 5);
                return true;
            }
            int cooldownTicks = (int)(20.0 / player.m_21133_(Attributes.f_22283_));
            if ((player.m_21205_().m_41720_() instanceof BrutalityThrowingItem || player.m_21206_().m_41720_() instanceof BrutalityThrowingItem) && player.m_21205_().m_41720_() == player.m_21206_().m_41720_()) {
                cooldownTicks /= 2;
            }
            player.m_36335_().m_41524_((Item)item, cooldownTicks);
            return true;
        }

        public static void handleAttributesAndAnimation(Player player, BrutalityThrowingItem throwingItem, ItemStack stack, boolean isOffhand) {
            if (!player.m_9236_().m_5776_()) {
                return;
            }
            ResourceLocation animationLocation = throwingItem.getAnimationResourceLocation();
            if (isOffhand) {
                ThrowableWeaponHelper.offhandAttributes(player, () -> {
                    ThrowableWeaponHelper.handleCooldownAndSound(player, stack, throwingItem);
                    ThrowableWeaponHelper.playThrowAnimation(player, animationLocation, true);
                });
            } else {
                ThrowableWeaponHelper.handleCooldownAndSound(player, stack, throwingItem);
                ThrowableWeaponHelper.playThrowAnimation(player, animationLocation, false);
            }
        }

        public static void playThrowAnimation(Player player, ResourceLocation animationLocation, boolean offHand) {
            float speed = 1.0f;
            KeyframeAnimation keyframeAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)animationLocation);
            if (keyframeAnimation != null) {
                float attackSpeed = (float)player.m_21133_(Attributes.f_22283_);
                float animationLength = new KeyframeAnimationPlayer(keyframeAnimation).getData().getLength();
                float targetDurationTicks = 20.0f / attackSpeed;
                speed = animationLength / targetDurationTicks;
            }
            AnimationHelper.playAnimation(player, animationLocation, offHand, speed);
            PacketHandler.sendToServer(new ServerboundPlayerAnimationPacket(player.m_20148_(), animationLocation, offHand, speed));
        }

        public static void handleCooldownAndSound(Player player, ItemStack stack, BrutalityThrowingItem throwingItem) {
            if (ThrowableWeaponHelper.handleCooldown(player, throwingItem)) {
                ThrowableWeaponHelper.playThrowSound(player);
                PacketHandler.sendToServer(new ServerboundHandleThrowingProjectilePacket(stack));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void offhandAttributes(Player player, Runnable runnable) {
            Object object = attributesLock;
            synchronized (object) {
                ThrowableWeaponHelper.setAttributesForOffHandAttack(player, true);
                runnable.run();
                ThrowableWeaponHelper.setAttributesForOffHandAttack(player, false);
            }
        }

        private static void playThrowSound(Player player) {
            player.m_5496_((SoundEvent)BrutalityModSounds.THROW.get(), 2.0f, Mth.m_216283_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f));
        }

        private static void setAttributesForOffHandAttack(Player player, boolean useOffHand) {
            ItemStack add;
            ItemStack remove;
            ItemStack mainHandStack = player.m_21205_();
            ItemStack offHandStack = player.m_21206_();
            if (useOffHand) {
                remove = mainHandStack;
                add = offHandStack;
            } else {
                remove = offHandStack;
                add = mainHandStack;
            }
            player.m_21204_().m_22161_(remove.m_41638_(EquipmentSlot.MAINHAND));
            player.m_21204_().m_22178_(add.m_41638_(EquipmentSlot.MAINHAND));
        }
    }
}

