/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client.player_animation;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.UUID;
import net.goo.brutality.config.BrutalityClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AnimationHelper {
    private static final HashMap<Player, SpeedModifier> speedModifierMap = new HashMap();
    private static final HashMap<Player, MirrorModifier> mirrorModifierMap = new HashMap();

    public static void playAnimation(Player player, ResourceLocation animationLocation, boolean mirrored, float speed) {
        AbstractClientPlayer abstractClientPlayer;
        ModifierLayer layer;
        KeyframeAnimation keyframeAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)animationLocation);
        if (keyframeAnimation != null && player instanceof AbstractClientPlayer && (layer = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)(abstractClientPlayer = (AbstractClientPlayer)player)).get(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"animation"))) != null) {
            KeyframeAnimationPlayer keyframeAnimationPlayer = new KeyframeAnimationPlayer(keyframeAnimation);
            boolean armsFlag = (Boolean)BrutalityClientConfig.THROWING_ANIMATION_SHOW_ARMS.get();
            boolean itemsFlag = (Boolean)BrutalityClientConfig.THROWING_ANIMATION_SHOW_ITEMS.get();
            if (armsFlag || itemsFlag) {
                keyframeAnimationPlayer.setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL);
                keyframeAnimationPlayer.setFirstPersonConfiguration(new FirstPersonConfiguration(armsFlag, armsFlag, itemsFlag, itemsFlag));
            } else {
                keyframeAnimationPlayer.setFirstPersonMode(FirstPersonMode.DISABLED);
            }
            SpeedModifier speedModifier = speedModifierMap.computeIfAbsent(player, k -> new SpeedModifier());
            MirrorModifier mirrorModifier = mirrorModifierMap.computeIfAbsent(player, k -> new MirrorModifier());
            mirrorModifier.setEnabled(mirrored);
            speedModifier.speed = speed;
            layer.addModifierBefore((AbstractModifier)mirrorModifier);
            layer.addModifierBefore((AbstractModifier)speedModifier);
            layer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (Ease)Ease.INOUTSINE), (IAnimation)keyframeAnimationPlayer, true);
        }
    }

    public static void playAnimation(UUID playerUUID, ResourceLocation animationLocation, boolean mirrored, float speed) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (playerUUID.equals(mc.f_91074_.m_20148_())) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)mc.f_91073_.m_46003_(playerUUID);
        if (player == null) {
            return;
        }
        AnimationHelper.playAnimation((Player)player, animationLocation, mirrored, speed);
    }
}

