/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.goo.brutality.Brutality;
import net.goo.brutality.block.custom.WhiteFilingCabinetBlock;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityArmorItem;
import net.goo.brutality.item.base.BrutalityBlockItem;
import net.goo.brutality.item.base.BrutalityBowItem;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.item.weapon.generic.TheCloudItem;
import net.goo.brutality.item.weapon.scythe.DarkinScythe;
import net.goo.brutality.item.weapon.sword.DullKnifeSword;
import net.goo.brutality.item.weapon.throwing.Mug;
import net.goo.brutality.registry.BrutalityModBlocks;
import net.goo.brutality.registry.BrutalityModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BrutalityItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();
    private static final Set<Class<? extends BrutalityGeoItem>> EXCLUDED_ITEMS;
    private final List<RegistryObject<Block>> excludedBlocks = List.of(BrutalityModBlocks.GRAY_OFFICE_CARPET, BrutalityModBlocks.LIGHT_GRAY_OFFICE_CARPET);

    public BrutalityItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "brutality", existingFileHelper);
    }

    private boolean isExcluded(BrutalityGeoItem item) {
        return EXCLUDED_ITEMS.contains(item.getClass());
    }

    protected void registerModels() {
        Collection items = BrutalityModItems.ITEMS.getEntries();
        Collection blocks = BrutalityModBlocks.BLOCKS.getEntries();
        for (RegistryObject item : items) {
            Item rawItem = (Item)item.get();
            if (rawItem instanceof BrutalityGeoItem) {
                BrutalityGeoItem geoItem = (BrutalityGeoItem)rawItem;
                if (this.isExcluded(geoItem)) continue;
                this.generateBrutalityGeoItemModel(geoItem);
                continue;
            }
            if (rawItem instanceof BrutalityBlockItem) {
                BrutalityBlockItem blockItem = (BrutalityBlockItem)rawItem;
                this.geoBlockItem(blockItem.m_40614_());
                continue;
            }
            if (item.get() instanceof BlockItem) continue;
            this.generatedItem((RegistryObject<Item>)item);
        }
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "brutality";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.m_135820_((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + itemRegistryObject.getId().m_135815_())));
            });
        }
    }

    private void simpleBrutalityItem(BrutalityGeoItem item) {
        String identifier = item.getRegistryName();
        ((ItemModelBuilder)this.withExistingParent(identifier, this.mcLoc("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + (item instanceof BrutalityCurioItem ? "curio/" : "") + item.getCategoryAsString() + "/" + identifier + "/" + identifier + "_inventory")));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("brutality:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), "item/handheld")).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + item.getId().m_135815_() + "_inventory")));
    }

    private void generatedItem(RegistryObject<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), "item/generated")).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + item.getId().m_135815_() + "_inventory")));
    }

    private ItemModelBuilder geoBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), "item/generated")).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + item.getId().m_135815_())));
    }

    public void geoBlockItem(Block block) {
        String path = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(path, ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + path + "_handheld")))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + path)));
    }

    private void simpleBlockItemBlockTexture(RegistryObject<Block> block) {
        if (block.getId() != null) {
            if (block.get() instanceof WhiteFilingCabinetBlock) {
                return;
            }
            ((ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), "item/generated")).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("block/" + block.getId().m_135815_())));
        }
    }

    private void generateBrutalityGeoItemModel(BrutalityGeoItem item) {
        String identifier = item.model(null) != null ? item.model(null) : item.getRegistryName();
        String folder = Objects.equals(item.category(), BrutalityCategories.ItemType.BLOCK) ? BrutalityCategories.ItemType.BLOCK.toString().toLowerCase() : "item";
        boolean isBlockItem = item instanceof BrutalityBlockItem;
        String category = isBlockItem ? "" : item.getCategoryAsString() + "/";
        ResourceLocation handheldTextureLoc = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)(folder + "/" + (item instanceof BrutalityCurioItem ? "curio/" : "") + category + identifier + (String)(isBlockItem ? "" : "/" + identifier + "_handheld")));
        ResourceLocation geoModelLoc = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("geo/" + folder + "/" + category + identifier + (isBlockItem ? "" : "_handheld") + ".geo.json"));
        ResourceLocation inventoryTextureLoc = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)(folder + "/" + category + identifier + "/" + identifier + "_inventory"));
        if (item instanceof BrutalityArmorItem) {
            BrutalityArmorItem armorItem = (BrutalityArmorItem)item;
            this.generateArmorModel(armorItem);
            System.out.println("Generating Armor Model for " + item);
        } else if (!this.existingFileHelper.exists(inventoryTextureLoc, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE) && this.existingFileHelper.exists(geoModelLoc, PackType.CLIENT_RESOURCES)) {
            System.out.println("Generating Handheld Only Model for " + item);
            this.generateHandheldOnlyModel(item);
        } else if (this.existingFileHelper.exists(handheldTextureLoc, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE) && this.existingFileHelper.exists(geoModelLoc, PackType.CLIENT_RESOURCES)) {
            System.out.println("Generating Separate Transforms Model for " + item);
            this.generateSeparateTransformsModel(item);
        } else {
            System.out.println("Generating Simple Item Model for " + item);
            this.simpleBrutalityItem(item);
        }
    }

    private void generateHandheldOnlyModel(BrutalityGeoItem item) {
        String identifier = item.getRegistryName();
        boolean isBlockItem = item instanceof BlockItem;
        String folder = item.category() == BrutalityCategories.ItemType.BLOCK ? BrutalityCategories.ItemType.BLOCK.toString().toLowerCase() : "item";
        String category = isBlockItem ? "" : item.getCategoryAsString() + "/";
        Object texturePath = isBlockItem ? "" : identifier + "/";
        String curioPath = item instanceof BrutalityCurioItem ? "curio/" : "";
        ((ItemModelBuilder)this.withExistingParent(identifier, ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)(folder + "/" + category + identifier + "_handheld")))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)(folder + "/" + curioPath + category + (String)texturePath + identifier + (isBlockItem ? "" : "_handheld"))));
    }

    private void generateArmorModel(BrutalityArmorItem item) {
        String identifier = item.getRegistryName();
        ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + item.getCategoryAsString() + "/" + identifier + "_inventory"));
        if (this.existingFileHelper.exists(textureLocation, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE)) {
            ((ItemModelBuilder)this.withExistingParent(identifier + (item instanceof BrutalityArmorItem ? "" : "_inventory"), this.mcLoc("item/generated"))).texture("layer0", textureLocation);
        } else {
            Brutality.LOGGER.warn("Skipping inventory model generation for {}: Texture {} does not exist", (Object)identifier, (Object)textureLocation);
        }
    }

    private JsonObject createModelWithPerspectives(JsonObject baseModel, String modelLocation) {
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", "minecraft:item/handheld");
        modelJson.addProperty("loader", "forge:separate_transforms");
        modelJson.add("base", (JsonElement)baseModel);
        JsonObject perspectives = new JsonObject();
        for (String perspectiveType : List.of("ground", "thirdperson_lefthand", "thirdperson_righthand", "firstperson_lefthand", "firstperson_righthand")) {
            JsonObject perspective = new JsonObject();
            perspective.addProperty("parent", modelLocation);
            perspectives.add(perspectiveType, (JsonElement)perspective);
        }
        modelJson.add("perspectives", (JsonElement)perspectives);
        return modelJson;
    }

    private void generateSeparateTransformsModel(BrutalityGeoItem item) {
        String identifier = item.getRegistryName();
        String texturePath = "item/" + (item instanceof BrutalityCurioItem ? "curio/" : "") + item.getCategoryAsString() + "/" + (String)(item instanceof BrutalityArmorItem ? "" : identifier + "/") + identifier + "_inventory";
        String textureLocation = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)texturePath).toString();
        String handheldModel = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + (item instanceof BrutalityCurioItem ? "curio/" : "") + item.getCategoryAsString() + "/" + identifier + "_handheld")).toString();
        JsonObject baseModelJson = ((ItemModelBuilder)this.withExistingParent(identifier, this.mcLoc("item/generated"))).toJson();
        if (item instanceof BrutalityBowItem) {
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", textureLocation);
            baseModelJson.add("textures", (JsonElement)textures);
            JsonArray overrides = new JsonArray();
            float[] pullValues = new float[]{0.0f, 0.65f, 0.9f};
            for (int i = 0; i < 3; ++i) {
                String variantModelName = identifier + "_inventory_pull_" + i;
                JsonObject texture = new JsonObject();
                texture.addProperty("layer0", textureLocation + "_pull_" + i);
                JsonObject predicate = new JsonObject();
                predicate.addProperty("pulling", (Number)1);
                predicate.addProperty("pull", (Number)Float.valueOf(pullValues[i]));
                JsonObject override = new JsonObject();
                override.add("predicate", (JsonElement)predicate);
                override.addProperty("model", "brutality:item/" + variantModelName);
                overrides.add((JsonElement)override);
                this.withExistingParent(identifier + "_inventory_pull_" + i, this.mcLoc("item/generated"));
                this.generatePullModel(item, i);
            }
            baseModelJson.add("overrides", (JsonElement)overrides);
            JsonObject texture = new JsonObject();
            texture.addProperty("layer0", textureLocation);
            JsonObject modelJson = this.createModelWithPerspectives(baseModelJson, handheldModel);
            this.saveModel(identifier, modelJson);
        } else {
            JsonObject textures = new JsonObject();
            textures.addProperty("layer0", textureLocation);
            baseModelJson.add("textures", (JsonElement)textures);
            JsonObject modelJson = this.createModelWithPerspectives(baseModelJson, handheldModel);
            this.saveModel(identifier, modelJson);
        }
    }

    private void generatePullModel(BrutalityGeoItem item, int pullStage) {
        String[] perspectiveNames;
        String identifier = item.getRegistryName();
        String modelName = identifier + "_inventory_pull_" + pullStage;
        String texturePath = "item/" + (item instanceof BrutalityCurioItem ? "curio/" : "") + item.getCategoryAsString() + "/" + identifier + "/" + identifier + "_inventory_pull_" + pullStage;
        String handheldModel = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("item/" + (item instanceof BrutalityCurioItem ? "curio/" : "") + item.getCategoryAsString() + "/" + identifier + "_handheld")).toString();
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", "minecraft:item/generated");
        modelJson.addProperty("loader", "forge:separate_transforms");
        JsonObject base = new JsonObject();
        base.addProperty("parent", "minecraft:item/generated");
        JsonObject baseTextures = new JsonObject();
        baseTextures.addProperty("layer0", ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)texturePath).toString());
        base.add("textures", (JsonElement)baseTextures);
        modelJson.add("base", (JsonElement)base);
        JsonObject perspectives = new JsonObject();
        for (String perspective : perspectiveNames = new String[]{"ground", "thirdperson_lefthand", "thirdperson_righthand", "firstperson_lefthand", "firstperson_righthand"}) {
            JsonObject perspectiveObj = new JsonObject();
            perspectiveObj.addProperty("parent", handheldModel);
            perspectives.add(perspective, (JsonElement)perspectiveObj);
        }
        modelJson.add("perspectives", (JsonElement)perspectives);
        this.saveModel(modelName, modelJson);
    }

    private void saveModel(String itemName, JsonObject modelJson) {
        Path path = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("brutality/models/item/" + itemName + ".json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)modelJson.toString(), new OpenOption[0]);
            Brutality.LOGGER.info("Saved model for {} at {}", (Object)itemName, (Object)path);
        }
        catch (IOException e) {
            Brutality.LOGGER.error("Failed to save model for {}", (Object)itemName, (Object)e);
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
        EXCLUDED_ITEMS = Set.of(DullKnifeSword.class, DarkinScythe.class, TheCloudItem.class, Mug.class, Mug.class);
    }
}

