/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.datagen;

import java.util.concurrent.CompletableFuture;
import net.goo.brutality.datagen.BrutalityBlockStateProvider;
import net.goo.brutality.datagen.BrutalityBlockTagGenerator;
import net.goo.brutality.datagen.BrutalityGlobalLootModifiersProvider;
import net.goo.brutality.datagen.BrutalityItemModelProvider;
import net.goo.brutality.datagen.BrutalityItemTagProvider;
import net.goo.brutality.datagen.BrutalityPoiTypeTagsProvider;
import net.goo.brutality.datagen.BrutalityRecipeProvider;
import net.goo.brutality.datagen.ModLootTableProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new BrutalityRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BrutalityBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BrutalityItemModelProvider(packOutput, existingFileHelper));
        BrutalityBlockTagGenerator blockTagGenerator = (BrutalityBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new BrutalityBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BrutalityItemTagProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BrutalityGlobalLootModifiersProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new BrutalityPoiTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

