/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.base;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BrutalityAbstractPhysicsThrowingProjectile
extends BrutalityAbstractThrowingProjectile
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Integer> BOUNCE_COUNT = SynchedEntityData.m_135353_(BrutalityAbstractPhysicsThrowingProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int bounceCount = 0;
    public float prevRoll;
    public float roll;
    public float prevYaw;
    public float yaw;
    public float prevPitch;
    public float pitch;
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BrutalityAbstractPhysicsThrowingProjectile(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public BrutalityAbstractPhysicsThrowingProjectile(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOUNCE_COUNT, (Object)0);
    }

    public int getBounceCount() {
        return (Integer)this.f_19804_.m_135370_(BOUNCE_COUNT);
    }

    public void setBounceCount(int count) {
        this.f_19804_.m_276349_(BOUNCE_COUNT, (Object)count, true);
        this.bounceCount = count;
    }

    public boolean m_6469_(DamageSource source, float pAmount) {
        Entity entity;
        if (source.m_276093_(DamageTypes.f_268464_) && (entity = source.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            Vec3 look = player.m_20154_().m_82490_(0.5 + player.m_21133_(Attributes.f_22282_));
            this.m_5834_();
            this.f_36703_ = false;
            this.m_20256_(look);
            return false;
        }
        return super.m_6469_(source, pAmount);
    }

    protected Vec3 getEntityBounceStrength() {
        return new Vec3(-0.01, -0.1, -0.01);
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_36703_) {
            this.m_20256_(this.m_20184_().m_82559_(this.getEntityBounceStrength()));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRoll = this.roll;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        Vec3 motion = this.m_20184_();
        float speed = (float)motion.m_82553_();
        if ((double)speed > 0.25 && !this.f_36703_) {
            if (!this.lockRoll()) {
                this.roll += speed * this.getRotationSpeed();
            }
            if (!this.lockYaw()) {
                this.yaw = (float)Math.atan2(motion.f_82481_, motion.f_82479_) * 57.295776f - 90.0f;
                this.yaw = Mth.m_14177_((float)this.yaw);
            }
            if (!this.lockPitch()) {
                this.pitch = (float)Math.atan2(motion.f_82480_, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)) * 57.295776f;
                this.pitch = Mth.m_14177_((float)this.pitch);
            }
        }
    }

    protected float getRotationSpeed() {
        return 30.0f;
    }

    protected boolean lockRoll() {
        return false;
    }

    protected boolean lockYaw() {
        return false;
    }

    protected boolean lockPitch() {
        return false;
    }

    protected int getBounceQuota() {
        return 5;
    }

    @Override
    protected void m_8060_(BlockHitResult hitResult) {
        if (this.f_36703_) {
            super.m_8060_(hitResult);
            return;
        }
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36706_ = 7;
        if (this.f_36703_) {
            return;
        }
        Vec3 normal = Vec3.m_82528_((Vec3i)hitResult.m_82434_().m_122436_());
        Vec3 incoming = this.m_20184_();
        Vec3 reflected = incoming.m_82546_(normal.m_82490_(2.0 * incoming.m_82526_(normal)));
        this.m_20256_(reflected.m_82490_((double)this.getBounciness()));
        Vec3 newPos = hitResult.m_82450_().m_82549_(reflected.m_82541_().m_82490_(0.1));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        if (this.m_36796_() > 0) {
            this.m_36767_((byte)(this.m_36796_() - 1));
        }
    }

    protected float getBounciness() {
        return 0.175f;
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        if (this.f_36703_) {
            return;
        }
        this.setBounceCount(this.getBounceCount() + 1);
        if (this.getBounceCount() >= this.getBounceQuota()) {
            this.f_36703_ = true;
            this.onFinalBounce(hitResult);
            if (this.shouldDiscardAfterBounce() && !this.m_9236_().m_5776_()) {
                DelayedTaskScheduler.queueServerWork(this.m_9236_(), 2, () -> ((BrutalityAbstractPhysicsThrowingProjectile)this).m_146870_());
            }
        }
        super.m_6532_(hitResult);
    }

    protected void onFinalBounce(HitResult result) {
    }

    protected boolean shouldDiscardAfterBounce() {
        return false;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getModelHeight() {
        return 1.0f;
    }
}

