/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.base;

import javax.annotation.Nullable;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractArrow;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BrutalityAbstractTrident
extends BrutalityAbstractArrow
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(BrutalityAbstractTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(BrutalityAbstractTrident.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack pickupItem = new ItemStack((ItemLike)Items.f_42713_);
    public int clientSideReturnTridentTickCount;
    private int targetsHit = 0;
    protected boolean dealtDamage = false;
    protected float damage;
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BrutalityAbstractTrident(EntityType<? extends BrutalityAbstractTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.damage = ModUtils.getAttackDamage(null);
    }

    public BrutalityAbstractTrident(EntityType<? extends BrutalityAbstractTrident> pEntityType, Player player, Level pLevel) {
        super(pEntityType, (LivingEntity)player, pLevel);
        this.damage = ModUtils.getAttackDamage((Entity)player);
    }

    public BrutalityAbstractTrident(Level pLevel, LivingEntity pShooter, ItemStack pStack, EntityType<? extends AbstractArrow> trident) {
        super(trident, pShooter, pLevel);
        this.pickupItem = pStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)net.minecraft.world.item.enchantment.EnchantmentHelper.m_44928_((ItemStack)pStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)pStack.m_41790_());
        this.damage = ModUtils.getAttackDamage((Entity)pShooter);
    }

    @Override
    public int getInGroundLifespan() {
        return 1200;
    }

    protected float m_6882_() {
        return 0.99f;
    }

    protected SoundEvent getChannelingLightningSoundEvent() {
        return SoundEvents.f_12521_;
    }

    protected boolean summonsLightningByDefault() {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.pickupItem;
    }

    protected Vec3 getTridentBounceStrength() {
        return new Vec3(-0.01, -0.1, -0.01);
    }

    protected int getHitQuota() {
        return 1;
    }

    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12515_;
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12514_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    @Override
    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity owner = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && owner != null) {
            if (!this.isAcceptableReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    protected boolean isAcceptableReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public boolean isChanneling() {
        return net.minecraft.world.item.enchantment.EnchantmentHelper.m_44936_((ItemStack)this.pickupItem);
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    public void m_6123_(Player pEntity) {
        if (!this.m_9236_().f_46443_ && (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0) {
            if (EnchantmentHelper.hasInfinity(this.m_7941_())) {
                pEntity.m_7938_((Entity)this, 0);
                this.m_146870_();
            } else if (this.m_142470_(pEntity)) {
                pEntity.m_7938_((Entity)this, 1);
                this.m_146870_();
            }
        }
    }

    protected boolean m_142470_(Player pPlayer) {
        ItemStack tridentStack = this.m_7941_();
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(tridentStack);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_(this.toString(), 10)) {
            this.pickupItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_(this.toString()));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)net.minecraft.world.item.enchantment.EnchantmentHelper.m_44928_((ItemStack)this.pickupItem)));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_(this.toString(), (Tag)this.pickupItem.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    @Override
    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_8060_(BlockHitResult pResult) {
        if (this.collideWithBlocks) {
            super.m_8060_(pResult);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        float f = this.damage;
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            f += net.minecraft.world.item.enchantment.EnchantmentHelper.m_44833_((ItemStack)this.pickupItem, (MobType)livingentity.m_6336_());
        }
        LivingEntity owner = (LivingEntity)this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        if (this.targetsHit < this.getHitQuota() - 1) {
            ++this.targetsHit;
        } else {
            this.dealtDamage = true;
        }
        SoundEvent soundEvent = this.getHitEntitySoundEvent();
        if (target.m_6469_(damagesource, f)) {
            if (target.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                if (owner != null) {
                    net.minecraft.world.item.enchantment.EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
                    net.minecraft.world.item.enchantment.EnchantmentHelper.m_44896_((LivingEntity)owner, (Entity)target);
                    this.m_7761_(livingentity);
                }
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(this.getTridentBounceStrength().f_82479_, this.getTridentBounceStrength().f_82480_, this.getTridentBounceStrength().f_82481_));
        float volume = 1.0f;
        if (this.m_9236_() instanceof ServerLevel && this.m_9236_().m_46470_() && this.isChanneling() || this.summonsLightningByDefault()) {
            LightningBolt lightningbolt;
            BlockPos blockpos = target.m_20183_();
            if (this.m_9236_().m_45527_(blockpos) && (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
                lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                lightningbolt.m_20879_(owner instanceof ServerPlayer ? (ServerPlayer)owner : null);
                this.m_9236_().m_7967_((Entity)lightningbolt);
                soundEvent = this.getChannelingLightningSoundEvent();
                volume = 5.0f;
            }
        }
        this.m_5496_(soundEvent, volume, 1.0f);
    }
}

