/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.capabilities;

import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brutality")
public class CapabilityAttacher {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)object;
            BrutalityCapabilities.CapabilitySyncRegistry.getAll().forEach((string, capability) -> {
                if (!entity.getCapability(capability).isPresent()) {
                    ICapabilityProvider provider = BrutalityCapabilities.CapabilitySyncRegistry.getProvider(capability);
                    event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)string), provider);
                }
            });
        } else {
            Capability<? extends INBTSerializable<CompoundTag>> capability2;
            Projectile projectile;
            object = event.getObject();
            if (object instanceof Projectile && !(projectile = (Projectile)object).getCapability(capability2 = BrutalityCapabilities.CapabilitySyncRegistry.get("seal_type")).isPresent()) {
                ICapabilityProvider provider = BrutalityCapabilities.CapabilitySyncRegistry.getProvider(capability2);
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"seal_type"), provider);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player oldPlayer = event.getOriginal();
            oldPlayer.reviveCaps();
            Player newPlayer = event.getEntity();
            BrutalityCapabilities.CapabilitySyncRegistry.getAll().forEach((string, capability) -> oldPlayer.getCapability(capability).ifPresent(oldCap -> newPlayer.getCapability(capability).ifPresent(newCap -> {
                CompoundTag tag = (CompoundTag)oldCap.serializeNBT();
                newCap.deserializeNBT((Tag)tag);
            })));
            if (newPlayer.m_9236_() instanceof ServerLevel) {
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(oldPlayer.m_19879_(), (Entity)oldPlayer));
            }
            oldPlayer.invalidateCaps();
        }
    }
}

