/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.explosion;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class BrutalityExplosion
extends Explosion {
    private final Map<Entity, Vec3> hitEntities = Maps.newHashMap();
    public float damageScale = 1.0f;
    public Float damage = null;
    Predicate<Entity> entityFilter = e -> true;
    protected Level.ExplosionInteraction explosionInteraction;

    public BrutalityExplosion(Level pLevel, @Nullable Entity pSource, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, List<BlockPos> pPositions) {
        this(pLevel, pSource, pToBlowX, pToBlowY, pToBlowZ, pRadius, false, Level.ExplosionInteraction.NONE, pPositions);
    }

    public BrutalityExplosion(Level pLevel, @Nullable Entity pSource, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, boolean pFire, Level.ExplosionInteraction explosionInteraction, List<BlockPos> pPositions) {
        this(pLevel, pSource, pToBlowX, pToBlowY, pToBlowZ, pRadius, pFire, explosionInteraction);
        this.f_46020_.addAll(pPositions);
    }

    public BrutalityExplosion(Level pLevel, @Nullable Entity pSource, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, boolean pFire, Level.ExplosionInteraction explosionInteraction) {
        this(pLevel, pSource, null, null, pToBlowX, pToBlowY, pToBlowZ, pRadius, pFire, explosionInteraction);
    }

    public BrutalityExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, boolean pFire, Level.ExplosionInteraction explosionInteraction) {
        super(pLevel, pSource, pDamageSource, pDamageCalculator, pToBlowX, pToBlowY, pToBlowZ, pRadius, pFire, Explosion.BlockInteraction.KEEP);
        this.explosionInteraction = explosionInteraction;
    }

    protected SimpleParticleType getParticleEmitter() {
        return ParticleTypes.f_123812_;
    }

    protected SimpleParticleType getParticle() {
        return ParticleTypes.f_123813_;
    }

    protected SoundEvent getExplosionSound() {
        return SoundEvents.f_11913_;
    }

    public Map<Entity, Vec3> getHitEntities() {
        return this.hitEntities;
    }

    public boolean getFire() {
        return this.f_46009_;
    }

    public float getRadius() {
        return this.f_46017_;
    }

    public Level.ExplosionInteraction getExplosionInteraction() {
        return this.explosionInteraction;
    }

    protected boolean needsInteractWithBlocksForEmitter() {
        return true;
    }

    public Predicate<Entity> getEntityFilter() {
        return this.entityFilter;
    }

    public void setEntityFilter(Predicate<Entity> entityFilter) {
        this.entityFilter = entityFilter;
    }

    public void m_46075_(boolean pSpawnParticles) {
        if (this.f_46012_.f_46443_) {
            this.f_46012_.m_7785_(this.f_46013_, this.f_46014_, this.f_46015_, this.getExplosionSound(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.m_188501_() - this.f_46012_.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean interactsWithBlocks = this.m_254884_();
        if (pSpawnParticles) {
            if (this.needsInteractWithBlocksForEmitter()) {
                if (!(this.f_46017_ < 2.0f) && interactsWithBlocks) {
                    this.f_46012_.m_7106_((ParticleOptions)this.getParticleEmitter(), this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
                } else {
                    this.f_46012_.m_7106_((ParticleOptions)this.getParticle(), this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
                }
            } else if (!(this.f_46017_ < 2.0f)) {
                this.f_46012_.m_7106_((ParticleOptions)this.getParticleEmitter(), this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
            } else {
                this.f_46012_.m_7106_((ParticleOptions)this.getParticle(), this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
            }
        }
        if (interactsWithBlocks) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag1 = this.m_252906_() instanceof Player;
            Util.m_214673_((ObjectArrayList)this.f_46020_, (RandomSource)this.f_46012_.f_46441_);
            for (BlockPos blockpos : this.m_46081_()) {
                Level level;
                BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                if (blockstate.m_60795_()) continue;
                BlockPos itemDropPos = blockpos.m_7949_();
                this.f_46012_.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.f_46012_, blockpos, (Explosion)this) && (level = this.f_46012_) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    BlockEntity blockentity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                    LootParams.Builder lootparams$builder = new LootParams.Builder(serverlevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.f_46016_);
                    if (this.f_46010_ == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        lootparams$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.f_46017_));
                    }
                    blockstate.m_222967_(serverlevel, blockpos, ItemStack.f_41583_, flag1);
                    blockstate.m_287290_(lootparams$builder).forEach(p_46074_ -> BrutalityExplosion.m_46067_((ObjectArrayList)objectarraylist, (ItemStack)p_46074_, (BlockPos)itemDropPos));
                }
                blockstate.onBlockExploded(this.f_46012_, blockpos, (Explosion)this);
                this.f_46012_.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.f_46009_) {
            for (BlockPos blowPos : this.m_46081_()) {
                if (this.f_46011_.m_188503_(3) != 0 || !this.f_46012_.m_8055_(blowPos).m_60795_() || !this.f_46012_.m_8055_(blowPos.m_7495_()).m_60804_((BlockGetter)this.f_46012_, blowPos.m_7495_())) continue;
                this.f_46012_.m_46597_(blowPos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)blowPos));
            }
        }
    }

    public void m_46061_() {
        this.f_46012_.m_220400_(this.f_46016_, GameEvent.f_157812_, new Vec3(this.f_46013_, this.f_46014_, this.f_46015_));
        HashSet affectedBlocks = Sets.newHashSet();
        int rayCount = 16;
        for (int rayX = 0; rayX < rayCount; ++rayX) {
            for (int rayY = 0; rayY < rayCount; ++rayY) {
                block2: for (int rayZ = 0; rayZ < rayCount; ++rayZ) {
                    if (rayX != 0 && rayX != 15 && rayY != 0 && rayY != 15 && rayZ != 0 && rayZ != 15) continue;
                    double directionX = (float)rayX / 15.0f * 2.0f - 1.0f;
                    double directionY = (float)rayY / 15.0f * 2.0f - 1.0f;
                    double directionZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    double magnitude = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
                    directionX /= magnitude;
                    directionY /= magnitude;
                    directionZ /= magnitude;
                    double currentX = this.f_46013_;
                    double currentY = this.f_46014_;
                    double currentZ = this.f_46015_;
                    float stepSize = 0.3f;
                    for (float rayStrength = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.m_188501_() * 0.6f); rayStrength > 0.0f; rayStrength -= 0.22500001f) {
                        BlockPos currentPos = BlockPos.m_274561_((double)currentX, (double)currentY, (double)currentZ);
                        BlockState blockState = this.f_46012_.m_8055_(currentPos);
                        FluidState fluidState = this.f_46012_.m_6425_(currentPos);
                        if (!this.f_46012_.m_46739_(currentPos)) continue block2;
                        Optional explosionResistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, currentPos, blockState, fluidState);
                        if (explosionResistance.isPresent()) {
                            rayStrength -= (((Float)explosionResistance.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (rayStrength > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, currentPos, blockState, rayStrength)) {
                            affectedBlocks.add(currentPos);
                        }
                        currentX += directionX * (double)0.3f;
                        currentY += directionY * (double)0.3f;
                        currentZ += directionZ * (double)0.3f;
                    }
                }
            }
        }
        this.f_46020_.addAll((Collection)affectedBlocks);
        float explosionDiameter = this.f_46017_ * 2.0f;
        int minX = Mth.m_14107_((double)(this.f_46013_ - (double)explosionDiameter - 1.0));
        int maxX = Mth.m_14107_((double)(this.f_46013_ + (double)explosionDiameter + 1.0));
        int minY = Mth.m_14107_((double)(this.f_46014_ - (double)explosionDiameter - 1.0));
        int maxY = Mth.m_14107_((double)(this.f_46014_ + (double)explosionDiameter + 1.0));
        int minZ = Mth.m_14107_((double)(this.f_46015_ - (double)explosionDiameter - 1.0));
        int maxZ = Mth.m_14107_((double)(this.f_46015_ + (double)explosionDiameter + 1.0));
        List nearbyEntities = this.f_46012_.m_45933_(this.f_46016_, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, (List)nearbyEntities, (double)explosionDiameter);
        Vec3 explosionCenter = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
        for (Entity entity : nearbyEntities) {
            double knockbackFactor;
            double deltaZ;
            double deltaY;
            double deltaX;
            double totalDistance;
            double distanceRatio;
            if (entity.m_6128_() || !this.getEntityFilter().test(entity) || !((distanceRatio = Math.sqrt(entity.m_20238_(explosionCenter)) / (double)explosionDiameter) <= 1.0) || (totalDistance = Math.sqrt((deltaX = entity.m_20185_() - this.f_46013_) * deltaX + (deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.f_46014_) * deltaY + (deltaZ = entity.m_20189_() - this.f_46015_) * deltaZ)) == 0.0) continue;
            deltaX /= totalDistance;
            deltaY /= totalDistance;
            deltaZ /= totalDistance;
            double visibilityFactor = BrutalityExplosion.m_46064_((Vec3)explosionCenter, (Entity)entity);
            double impactFactor = (1.0 - distanceRatio) * visibilityFactor;
            entity.m_6469_(this.m_46077_(), this.damageScale * Objects.requireNonNullElseGet(this.damage, () -> Float.valueOf((float)((impactFactor * impactFactor + impactFactor) / 2.0 * 7.0 * (double)explosionDiameter + 1.0))).floatValue());
            this.onHit(entity, impactFactor);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                knockbackFactor = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)impactFactor);
            } else {
                knockbackFactor = impactFactor;
            }
            Vec3 knockbackVector = new Vec3(deltaX *= knockbackFactor, deltaY *= knockbackFactor, deltaZ *= knockbackFactor);
            entity.m_20256_(entity.m_20184_().m_82549_(knockbackVector));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
                this.f_46021_.put(player, knockbackVector);
                continue;
            }
            this.hitEntities.put(entity, knockbackVector);
        }
    }

    public void onHit(Entity entity, double impactFactor) {
    }
}

