/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.beam;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.goo.brutality.entity.base.SwordBeam;
import net.goo.brutality.registry.BrutalityModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ExcaliburBeam
extends SwordBeam {
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private boolean trailSpawned = false;

    public ExcaliburBeam(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level, 45, 65);
    }

    @Override
    public int getLifespan() {
        return 50;
    }

    @Override
    public float getDamage() {
        return 15.0f;
    }

    @Override
    public float getInertia() {
        return 1.075f;
    }

    @Override
    public int getPierceCap() {
        return 0;
    }

    @Override
    public float getRenderScale() {
        return 5.0f;
    }

    @Override
    public SimpleParticleType getHitParticle() {
        return (SimpleParticleType)BrutalityModParticles.SPARKLE_PARTICLE.get();
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
    }

    @Override
    public void m_8119_() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (!this.trailSpawned && this.m_9236_().m_5776_()) {
            Vec3 moveVec = this.m_20184_();
            moveVec = moveVec.m_82541_();
            float yaw = (float)Math.atan2(-moveVec.f_82481_, moveVec.f_82479_);
            float pitch = (float)Math.asin(moveVec.f_82480_);
            this.trailSpawned = true;
        }
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        AABB hitbox = this.m_20191_();
        List entities = this.m_9236_().m_6249_((Entity)this, hitbox, x$0 -> this.m_5603_((Entity)x$0));
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                UUID entityId = entity.m_20148_();
                if (this.hitEntities.contains(entityId)) continue;
                entity.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), this.getDamage());
                this.hitEntities.add(entityId);
            }
        }
        this.m_9236_().m_7106_((ParticleOptions)BrutalityModParticles.SPARKLE_PARTICLE.get(), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 1.0, 0.0, 0.0);
        if (this.m_20184_().m_82553_() < 0.1) {
            this.hitEntities.clear();
            this.m_146870_();
        }
        super.m_8119_();
    }
}

