/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.beam;

import net.goo.brutality.entity.base.SwordBeam;
import net.goo.brutality.registry.BrutalityModParticles;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class TerraBeam
extends SwordBeam {
    private boolean trailSpawned = false;

    public TerraBeam(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level, -15, 15);
        this.shouldNoClip = true;
    }

    @Override
    public float getDamage() {
        return 7.5f;
    }

    @Override
    public float getInertia() {
        return 0.875f;
    }

    @Override
    public int getPierceCap() {
        return 3;
    }

    @Override
    public SimpleParticleType getHitParticle() {
        return (SimpleParticleType)BrutalityModParticles.TERRA_PARTICLE.get();
    }

    @Override
    public void m_8119_() {
        HitResult hitresult;
        if (!this.trailSpawned && this.m_9236_().m_5776_()) {
            Vec3 moveVec = this.m_20184_();
            moveVec = moveVec.m_82541_();
            float yaw = (float)Math.atan2(-moveVec.f_82481_, moveVec.f_82479_);
            float pitch = (float)Math.asin(moveVec.f_82480_);
            this.trailSpawned = true;
        }
        if ((hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        if (this.m_20184_().m_82553_() < 0.1) {
            this.m_146870_();
        }
        super.m_8119_();
    }
}

