/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident.physics_projectile;

import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsThrowingProjectile;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CinderBlock
extends BrutalityAbstractPhysicsThrowingProjectile {
    public CinderBlock(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public CinderBlock(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    @Override
    public int getInGroundLifespan() {
        return 200;
    }

    @Override
    public float getModelHeight() {
        return 4.0f;
    }

    @Override
    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12446_;
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12446_;
    }

    @Override
    protected float getBounciness() {
        return 0.0f;
    }

    @Override
    protected int getBounceQuota() {
        return 0;
    }

    @Override
    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        if (((Boolean)BrutalityCommonConfig.THROWING_WEAPONS_BREAK_BLOCKS.get()).booleanValue()) {
            return;
        }
        BlockPos pos = hitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        float destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        if (destroySpeed <= 0.3f) {
            this.m_9236_().m_46961_(pos, true);
        }
    }

    @Override
    public float getGravity() {
        return 0.1f;
    }

    @Override
    protected Vec3 getEntityBounceStrength() {
        return super.getEntityBounceStrength().m_82490_(2.0);
    }
}

