/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident.physics_projectile;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsThrowingProjectile;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.entity.explosion.NapalmExplosion;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PerfumeBottle
extends BrutalityAbstractPhysicsThrowingProjectile
implements BrutalityGeoEntity {
    public PerfumeBottle(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public PerfumeBottle(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    @Override
    public int getInGroundLifespan() {
        return 200;
    }

    @Override
    public float getModelHeight() {
        return 8.0f;
    }

    @Override
    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12436_;
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12436_;
    }

    @Override
    protected float getBounciness() {
        return 0.0f;
    }

    @Override
    protected int getBounceQuota() {
        return 0;
    }

    @Override
    protected boolean shouldDiscardAfterBounce() {
        return true;
    }

    @Override
    protected void m_6532_(@NotNull HitResult hitResult) {
        super.m_6532_(hitResult);
        this.m_146870_();
        Vec3 loc = hitResult.m_82450_();
        float radius = 2.5f;
        AABB aabb = this.m_20191_().m_82400_((double)radius);
        boolean isExplosive = this.m_9236_().m_46847_(aabb).anyMatch(block -> block.m_204336_(BlockTags.f_13076_) || block.m_60713_(Blocks.f_49991_));
        if (isExplosive) {
            NapalmExplosion explosion = new NapalmExplosion(this.m_9236_(), this.m_19749_(), null, null, loc.f_82479_, loc.f_82480_, loc.f_82481_, 3.0f, true, ModUtils.getThrowingWeaponExplosionInteractionFromConfig());
            explosion.setEntityFilter(e -> e != this.m_19749_());
            ModExplosionHelper.Server.explode(explosion, this.m_9236_(), true);
        } else {
            LivingEntity target;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.PERFUME_PARTICLE.get()), loc.f_82479_, loc.f_82480_, loc.f_82481_, 200, (double)radius, (double)radius, (double)radius, 0.0);
            }
            if ((target = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(e -> e != this.m_19749_()), null, loc.f_82479_, loc.f_82480_, loc.f_82481_, aabb)) != null) {
                this.m_9236_().m_45971_(Mob.class, TargetingConditions.f_26872_, target, target.m_20191_().m_82400_((double)radius)).forEach(e -> {
                    e.m_21561_(true);
                    e.m_6710_(target);
                });
            }
        }
    }
}

