/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident.physics_projectile;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsThrowingProjectile;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.particle.providers.WaveParticleData;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class SculkGrenade
extends BrutalityAbstractPhysicsThrowingProjectile
implements BrutalityGeoEntity {
    public SculkGrenade(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public SculkGrenade(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    @Override
    public int getInGroundLifespan() {
        return 200;
    }

    @Override
    public float getModelHeight() {
        return 6.0f;
    }

    @Override
    @NotNull
    public SoundEvent m_36784_() {
        return (SoundEvent)BrutalityModSounds.ZAP.get();
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return (SoundEvent)BrutalityModSounds.ZAP.get();
    }

    @Override
    protected float getBounciness() {
        return 0.6f;
    }

    @Override
    protected int getBounceQuota() {
        return 3;
    }

    @Override
    protected boolean shouldDiscardAfterBounce() {
        return true;
    }

    @Override
    protected void m_6532_(@NotNull HitResult hitResult) {
        DamageSource damageSource;
        super.m_6532_(hitResult);
        WaveParticleData waveParticleData = new WaveParticleData((ParticleType)BrutalityModParticles.SONIC_WAVE.get(), 2.5f, 50);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            damageSource = this.m_269291_().m_269333_(living);
        } else {
            entity = this.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                damageSource = this.m_269291_().m_269075_(player);
            } else {
                damageSource = this.m_269291_().m_269264_();
            }
        }
        this.m_9236_().m_7106_(waveParticleData, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ModUtils.applyWaveEffect(serverLevel, (Entity)this, LivingEntity.class, waveParticleData, e -> e != this.m_19749_(), e -> {
                e.f_19802_ = 0;
                e.m_6469_(damageSource, this.damage.floatValue());
                ((LivingEntity)e).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 10));
            });
        }
    }
}

