/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.spells.brimwielder;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsProjectile;
import net.goo.brutality.entity.explosion.BloodExplosion;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.magic.spells.voidwalker.GraviticImplosionSpell;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChthonicCapsuleEntity
extends BrutalityAbstractPhysicsProjectile
implements BrutalityGeoEntity,
IBrutalitySpellEntity {
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_DATA = SynchedEntityData.m_135353_(ChthonicCapsuleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ChthonicCapsuleEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public float getSizeScaling() {
        return 2.0f;
    }

    @Override
    public float getModelHeight() {
        return 8.0f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    public int getSpellLevel() {
        return (Integer)this.f_19804_.m_135370_(SPELL_LEVEL_DATA);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_LEVEL_DATA, (Object)1);
    }

    @Override
    public void setSpellLevel(int spellLevel) {
        this.f_19804_.m_135381_(SPELL_LEVEL_DATA, (Object)spellLevel);
    }

    @Override
    public BrutalitySpell getSpell() {
        return new GraviticImplosionSpell();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("spell_level")) {
            this.setSpellLevel(tag.m_128451_("spell_level"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_level", this.getSpellLevel());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            this.lockPitch();
            this.lockRoll();
            this.lockYaw();
        }
        if (this.f_36704_ >= 100) {
            this.doExplosion();
            if (this.f_36704_ > 100) {
                this.m_146870_();
            }
        }
    }

    @Override
    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.triggerAnim("controller", "impact");
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        this.doExplosion();
        this.m_146870_();
    }

    private void doExplosion() {
        BloodExplosion explosion = new BloodExplosion(this.m_9236_(), this.m_19749_(), null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, false, Level.ExplosionInteraction.NONE);
        explosion.damage = Float.valueOf(this.getFinalDamage(this.getSpell(), this.m_19749_(), this.getSpellLevel()));
        explosion.setEntityFilter(e -> !(e instanceof ChthonicCapsuleEntity) && e != this.m_19749_());
        ModExplosionHelper.Server.explode(explosion, this.m_9236_(), true);
        float size = this.getSpell().getFinalStat(this.getSpellLevel(), this.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE));
        this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_((double)size), e -> e != this).forEach(e -> {
            Vec3 pushAng = e.m_20318_(1.0f).m_82546_(this.m_20318_(1.0f));
            pushAng.m_82541_().m_82490_((double)((float)this.getSpellLevel() / 3.0f));
            e.m_5997_(pushAng.m_7096_(), pushAng.m_7098_(), pushAng.m_7094_());
            if (e instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)e;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
        });
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)BrutalityModSounds.SQUELCH.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> PlayState.CONTINUE).triggerableAnim("impact", RawAnimation.begin().thenPlayAndHold("impact"))});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected int getBounceCount() {
        return 0;
    }
}

