/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.spells.voidwalker;

import java.util.List;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsProjectile;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.magic.spells.voidwalker.GraviticImplosionSpell;
import net.goo.brutality.network.ClientboundParticlePacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityModSounds;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GraviticImplosionEntity
extends BrutalityAbstractPhysicsProjectile
implements BrutalityGeoEntity,
IBrutalitySpellEntity {
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_DATA = SynchedEntityData.m_135353_(GraviticImplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GraviticImplosionEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public float getSizeScaling() {
        return 0.5f;
    }

    @Override
    public float getModelHeight() {
        return 8.0f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    public int getSpellLevel() {
        return (Integer)this.f_19804_.m_135370_(SPELL_LEVEL_DATA);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_LEVEL_DATA, (Object)1);
    }

    @Override
    protected int getLifespan() {
        return 100;
    }

    @Override
    public void setSpellLevel(int spellLevel) {
        this.f_19804_.m_135381_(SPELL_LEVEL_DATA, (Object)spellLevel);
    }

    @Override
    public BrutalitySpell getSpell() {
        return new GraviticImplosionSpell();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("spell_level")) {
            this.setSpellLevel(tag.m_128451_("spell_level"));
        }
    }

    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_271165_;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_level", this.getSpellLevel());
    }

    @Override
    public float getGravity() {
        return 0.025f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            this.lockPitch();
            this.lockRoll();
            this.lockYaw();
        }
        if (this.f_36704_ > 20) {
            this.m_146870_();
        }
    }

    @Override
    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.triggerAnim("controller", "impact");
        int spellLevel = this.getSpellLevel();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DelayedTaskScheduler.queueServerWork((Level)serverLevel, 6, () -> this.m_5496_((SoundEvent)BrutalityModSounds.SPACE_EXPLOSION.get(), Math.min(spellLevel, 50), 1.5f - (float)spellLevel / 50.0f));
            DelayedTaskScheduler.queueServerWork((Level)serverLevel, 15, () -> {
                for (int i = 0; i < 16 + spellLevel * 4; ++i) {
                    float randomX = (float)this.m_20208_(5 + spellLevel);
                    float randomY = (float)this.m_20227_(this.f_19796_.m_188500_() * (double)(5 + spellLevel));
                    float randomZ = (float)this.m_20262_(5 + spellLevel);
                    PacketHandler.sendToNearbyClients(serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), 128.0, new ClientboundParticlePacket((SimpleParticleType)TerramityModParticleTypes.ANTIMATTER.get(), true, randomX, randomY, randomZ, 0.0f, 0.0f, 0.0f, (float)(this.m_20185_() - (double)randomX) * (0.035f + 0.015f * (float)(spellLevel + 1)), (float)(this.m_20186_() - (double)randomY) * (0.035f + 0.015f * (float)(spellLevel + 1)), (float)(this.m_20189_() - (double)randomZ) * (0.035f + 0.015f * (float)(spellLevel + 1)), 1));
                }
                List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)((float)spellLevel / 2.0f + 3.0f)), e -> e instanceof LivingEntity && (!(e instanceof Player) || !e.m_5833_() && !((Player)e).m_7500_()));
                for (Entity entity : nearbyEntities) {
                    if (entity == this || entity == this.m_19749_()) continue;
                    Vec3 targetPos = entity.m_20318_(1.0f);
                    Vec3 sourcePos = this.m_20318_(1.0f).m_82520_(0.0, (double)this.m_20206_(), 0.0);
                    Vec3 targetVector = sourcePos.m_82546_(targetPos).m_82541_();
                    entity.m_246865_(targetVector.m_82490_((double)0.15f).m_82490_((double)((float)(1 + spellLevel) / 2.0f)));
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                    }
                    float finalDamage = this.getSpell().getFinalDamage(this.m_19749_(), spellLevel);
                    if (this.m_19749_() != null) {
                        entity.m_6469_(entity.m_269291_().m_269104_(this.m_19749_(), null), finalDamage);
                        continue;
                    }
                    entity.m_6469_(entity.m_269291_().m_269425_(), finalDamage);
                }
            });
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        this.m_20242_(true);
        this.m_20334_(0.0, 0.0, 0.0);
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_271165_;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle"))).triggerableAnim("impact", RawAnimation.begin().thenPlayAndHold("impact"))});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected int getBounceCount() {
        return 0;
    }
}

