/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.forge;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DelayedTaskScheduler {
    private static final Map<Level, ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>> tasksPerLevel = new HashMap<Level, ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>>();

    public static void queueServerWork(Level level, int tick, Runnable action) {
        if (!level.m_5776_()) {
            tasksPerLevel.computeIfAbsent(level, k -> new ConcurrentLinkedQueue()).add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;
        if (!event.level.m_5776_() && event.phase == TickEvent.Phase.END && (workQueue = tasksPerLevel.get(event.level)) != null) {
            ArrayList actions = new ArrayList();
            workQueue.forEach((Consumer<AbstractMap.SimpleEntry<Runnable, Integer>>)((Consumer<AbstractMap.SimpleEntry>)work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() <= 0) {
                    actions.add(work);
                }
            }));
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            tasksPerLevel.remove((ServerLevel)event.getLevel());
        }
    }
}

