/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.forge;

import java.util.Map;
import java.util.stream.Collectors;
import net.goo.brutality.item.base.BrutalityScytheItem;
import net.goo.brutality.registry.BrutalityModItems;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeGrindstoneHandler {
    @SubscribeEvent
    public static void onGrindstoneUse(GrindstoneEvent.OnPlaceItem event) {
        ItemStack targetStack;
        ItemStack bottomItem = event.getBottomItem();
        ItemStack topItem = event.getTopItem();
        ItemStack itemStack = targetStack = bottomItem.m_41619_() ? topItem : bottomItem;
        if (targetStack.m_41720_() == BrutalityModItems.THUNDERBOLT_TRIDENT.get()) {
            ForgeGrindstoneHandler.handleGrindstoneEvent(event, targetStack, Map.of(Enchantments.f_44955_, 5, Enchantments.f_44952_, 1), Map.of(Enchantments.f_44955_, 5, Enchantments.f_44952_, 1));
        } else if (targetStack.m_41720_() == BrutalityModItems.TERRATON_HAMMER.get()) {
            ForgeGrindstoneHandler.handleGrindstoneEvent(event, targetStack, Map.of(Enchantments.f_44980_, 4), Map.of(Enchantments.f_44980_, 4));
        } else if (targetStack.m_41720_() instanceof BrutalityScytheItem) {
            ForgeGrindstoneHandler.handleGrindstoneEvent(event, targetStack, Map.of(Enchantments.f_44983_, 5), Map.of(Enchantments.f_44983_, 5));
        } else if (targetStack.m_41720_() == BrutalityModItems.SUPERNOVA.get()) {
            ForgeGrindstoneHandler.handleGrindstoneEvent(event, targetStack, Map.of(Enchantments.f_44983_, 5), Map.of(Enchantments.f_44980_, 3));
        }
    }

    private static void handleGrindstoneEvent(GrindstoneEvent.OnPlaceItem event, ItemStack targetStack, Map<Enchantment, Integer> allowedEnchantments, Map<Enchantment, Integer> forcedEnchantments) {
        ItemStack resultStack = targetStack.m_41777_();
        Map<Enchantment, Integer> enchantments = EnchantmentHelper.m_44831_((ItemStack)resultStack);
        enchantments = enchantments.entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).m_6589_() || allowedEnchantments.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        enchantments.putAll(forcedEnchantments);
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)resultStack);
        event.setXp(0);
        event.setOutput(resultStack);
    }
}

