/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.forge.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.item.weapon.generic.LastPrismItem;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.BrutalityEntityRotations;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.event.GeoRenderEvent;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BrutalityForgeEntityRenderHandler
extends RenderStateShard {
    public BrutalityForgeEntityRenderHandler(String pName, Runnable pSetupState, Runnable pClearState) {
        super(pName, pSetupState, pClearState);
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics gui = event.getGuiGraphics();
        if (mc.f_91074_ == null) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)mc.f_91074_).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.SANGUINE_SPECTACLES.get()).ifPresent(slot -> {
            f_110139_.m_110185_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            mc.f_91065_.m_280155_(gui, ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/sanguine_spectacles_overlay.png"), 1.0f);
            f_110139_.m_110188_();
        }));
    }

    @SubscribeEvent
    public static void onRenderSpell(GeoRenderEvent.Entity.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof IBrutalitySpellEntity) {
            IBrutalitySpellEntity entity2 = (IBrutalitySpellEntity)entity;
            int spellLevel = entity2.getSpellLevel();
            if (spellLevel < 1) {
                return;
            }
            float scaleIncrement = entity2.getSizeScaling();
            if (scaleIncrement == 0.0f) {
                return;
            }
            float finalScale = 1.0f + (float)(spellLevel - 1) * scaleIncrement;
            BrutalitySpell spell = entity2.getSpell();
            BrutalityTooltipHelper.SpellStatComponent sizeStat = spell.getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE);
            if (sizeStat == null) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85849_();
            poseStack.m_85841_(finalScale, finalScale, finalScale);
            poseStack.m_85836_();
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_21205_().m_41720_() instanceof LastPrismItem && event.getHand() == InteractionHand.OFF_HAND) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity, M extends EntityModel<T>> void onLivingRender(RenderLivingEvent.Pre<T, M> event) {
        LivingEntity entity = event.getEntity();
        PoseStack poseStack = event.getPoseStack();
        float partialTick = event.getPartialTick();
        int packedLight = event.getPackedLight();
        LivingEntityRenderer renderer = event.getRenderer();
        EntityModel model = renderer.m_7200_();
        MultiBufferSource originalBuffer = event.getMultiBufferSource();
        if (entity.getCapability(BrutalityCapabilities.ENTITY_EFFECT_CAP).map(EntityCapabilities.EntityEffectCap::isRage).orElse(false).booleanValue()) {
            poseStack.m_85841_(1.25f, 1.25f, 1.25f);
        }
        if (entity instanceof BrutalityEntityRotations) {
            BrutalityEntityRotations rotations = (BrutalityEntityRotations)entity;
            entity.getCapability(BrutalityCapabilities.ENTITY_SHOULD_ROTATE_CAP).ifPresent(entityShouldRotateCap -> {
                if (entityShouldRotateCap.isShouldRotate()) {
                    float lerpedRoll = Mth.m_14179_((float)partialTick, (float)rotations.brutality$getBrutalityPrevRoll(), (float)rotations.brutality$getBrutalityRoll());
                    float lerpedYaw = Mth.m_14179_((float)partialTick, (float)rotations.brutality$getBrutalityPrevYaw(), (float)rotations.brutality$getBrutalityYaw());
                    float lerpedPitch = Mth.m_14179_((float)partialTick, (float)rotations.brutality$getBrutalityPrevPitch(), (float)rotations.brutality$getBrutalityPitch());
                    float halfHeight = entity.m_20206_() / 2.0f;
                    poseStack.m_252880_(0.0f, halfHeight, 0.0f);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(lerpedYaw));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(lerpedPitch));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(lerpedRoll));
                    poseStack.m_252880_(0.0f, -halfHeight, 0.0f);
                }
            });
        }
    }
}

