/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.forge.client;

import java.util.List;
import net.goo.brutality.entity.projectile.generic.BlackHole;
import net.goo.brutality.entity.projectile.trident.ThrownThunderbolt;
import net.goo.brutality.entity.spells.cosmic.CosmicCataclysmEntity;
import net.goo.brutality.item.weapon.sword.SupernovaSword;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.util.ModUtils;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientParticleHandler {
    static float blackHoleParticleSpawnRadius = 6.0f;
    static float blackHoleParticleSpeedFactor = 0.05f;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (level == null || player == null) {
            return;
        }
        int tickCount = mc.f_91074_.f_19797_;
        Item mainHandItem = player.m_21205_().m_41720_();
        Item offHandItem = player.m_21206_().m_41720_();
        if (level.m_5776_()) {
            int random;
            ForgeClientParticleHandler.spawnMiracleBlightParticles((Player)player, (Level)level);
            if (tickCount % 10 == 0 && (mainHandItem instanceof SupernovaSword || offHandItem instanceof SupernovaSword)) {
                level.m_7106_((ParticleOptions)ModUtils.getRandomParticle(BrutalityModParticles.COSMIC_PARTICLE), player.m_20208_(0.5), player.m_20187_(), player.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            if (tickCount % 2 == 0) {
                ForgeClientParticleHandler.spawnBlackHoleEntityParticles((Player)player, (Level)level);
                ForgeClientParticleHandler.spawnCosmicCataclysmParticles((Player)player, (Level)level);
            }
            if (tickCount % (random = level.f_46441_.m_216332_(15, 35)) == 0) {
                if (player.m_21055_((Item)BrutalityModItems.THUNDERBOLT_TRIDENT.get())) {
                    ForgeClientParticleHandler.spawnZeusThunderboltParticle((Player)player, (Level)level);
                }
                ForgeClientParticleHandler.spawnThrownThunderboltEntityParticle((Player)player, (Level)level);
            }
        }
    }

    private static void spawnZeusThunderboltParticle(Player player, Level level) {
        double offsetX = ((double)level.f_46441_.m_188501_() - 0.5) * 1.5;
        double offsetY = (double)level.f_46441_.m_188501_() * 1.5;
        double offsetZ = ((double)level.f_46441_.m_188501_() - 0.5) * 1.5;
        Vec3 particlePosition = player.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
        level.m_7106_((ParticleOptions)TerramityModParticleTypes.ELECTRIC_SHOCK_PARTICLE.get(), particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, 0.0, 0.0, 0.0);
    }

    private static void spawnThrownThunderboltEntityParticle(Player player, Level level) {
        List thrownZeusThunderbolts = level.m_45976_(ThrownThunderbolt.class, player.m_20191_().m_82400_(100.0));
        float particleSpawnRadius = 1.0f;
        if (!thrownZeusThunderbolts.isEmpty()) {
            for (ThrownThunderbolt thrownZeusThunderbolt : thrownZeusThunderbolts) {
                double offsetX = ((double)level.f_46441_.m_188501_() - 0.5) * (double)particleSpawnRadius;
                double offsetY = ((double)level.f_46441_.m_188501_() - 0.5) * (double)particleSpawnRadius;
                double offsetZ = ((double)level.f_46441_.m_188501_() - 0.5) * (double)particleSpawnRadius;
                Vec3 particlePosition = thrownZeusThunderbolt.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
                level.m_7106_((ParticleOptions)TerramityModParticleTypes.ELECTRIC_SHOCK_PARTICLE.get(), particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void spawnCosmicCataclysmParticles(Player player, Level level) {
        List entities = level.m_45976_(CosmicCataclysmEntity.class, player.m_20191_().m_82400_(50.0));
        for (CosmicCataclysmEntity spellEntity : entities) {
            int spellLevel = spellEntity.getSpellLevel() / 2;
            double offsetX = Mth.m_216267_((RandomSource)level.f_46441_, (float)(-spellLevel), (float)spellLevel);
            double offsetY = Mth.m_216267_((RandomSource)level.f_46441_, (float)(-spellLevel), (float)spellLevel);
            double offsetZ = Mth.m_216267_((RandomSource)level.f_46441_, (float)(-spellLevel), (float)spellLevel);
            Vec3 particlePosition = spellEntity.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
            level.m_7106_((ParticleOptions)ModUtils.getRandomParticle(BrutalityModParticles.COSMIC_PARTICLE), particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private static void spawnBlackHoleEntityParticles(Player player, Level level) {
        List blackHoleEntities = level.m_45976_(BlackHole.class, player.m_20191_().m_82400_(50.0));
        for (BlackHole blackHole : blackHoleEntities) {
            double offsetX = ((double)level.f_46441_.m_188501_() - 0.5) * (double)blackHoleParticleSpawnRadius;
            double offsetY = ((double)level.f_46441_.m_188501_() - 0.5) * (double)blackHoleParticleSpawnRadius;
            double offsetZ = ((double)level.f_46441_.m_188501_() - 0.5) * (double)blackHoleParticleSpawnRadius;
            Vec3 particlePosition = blackHole.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
            Vec3 particleDirection = blackHole.m_20182_().m_82546_(particlePosition).m_82490_((double)blackHoleParticleSpeedFactor);
            level.m_7106_((ParticleOptions)BrutalityModParticles.BLACK_HOLE_PARTICLE.get(), particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, particleDirection.f_82479_, particleDirection.f_82480_, particleDirection.f_82481_);
        }
    }

    private static void spawnMiracleBlightParticles(Player player, Level level) {
        List nearbyEntities = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(50.0));
        for (LivingEntity entity : nearbyEntities) {
            entity.getCapability(BrutalityCapabilities.ENTITY_EFFECT_CAP).ifPresent(cap -> {
                if (cap.isMiracleBlighted()) {
                    double offsetX = ((double)level.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_() * 1.5;
                    double offsetY = ((double)level.f_46441_.m_188501_() - 0.5) * (double)entity.m_20206_() * 1.5;
                    double offsetZ = ((double)level.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_() * 1.5;
                    Vec3 entityMiddle = entity.m_20318_(1.0f).m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                    Vec3 particlePosition = entityMiddle.m_82520_(offsetX, offsetY, offsetZ);
                    Vec3 particleDirection = entityMiddle.m_82546_(particlePosition).m_82490_(0.25);
                    level.m_7106_((ParticleOptions)BrutalityModParticles.MIRACLE_BLIGHT_PARTICLE.get(), particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, particleDirection.f_82479_, particleDirection.f_82480_, particleDirection.f_82481_);
                }
            });
        }
    }
}

