/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.goo.brutality.config.BrutalityClientConfig;
import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.event.forge.client.ClientTickHandler;
import net.goo.brutality.gui.RadialProgressBarRenderer;
import net.goo.brutality.item.curios.charm.Sum;
import net.goo.brutality.item.weapon.tome.BaseMagicTome;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellCastingHandler;
import net.goo.brutality.magic.SpellCooldownTracker;
import net.goo.brutality.magic.SpellStorage;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModGui {
    private static final int SCREEN_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)42, (int)45, (int)11);
    private static final int SCREEN_WIDTH = 86;
    private static final int SCREEN_HEIGHT = 37;
    private static final int CALC_PADDING_X = 7;
    private static final int CALC_PADDING_Y = 8;
    private static final int GRAPH_PADDING = 2;
    private static final int CALC_WIDTH = 100;
    private static final float RANGE = (float)Math.PI * 2;
    private static final float AMPLITUDE_SCALE = 0.75f;
    private static final float SINE_AMPLITUDE = 3.75f;
    private static final float COSINE_AMPLITUDE = 0.75f;
    private static final int SINE_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)67, (int)74, (int)172);
    private static final int COSINE_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)182, (int)87, (int)103);
    private static final int GUI_WHITE = FastColor.ARGB32.m_13660_((int)255, (int)250, (int)252, (int)255);
    private static final int GUI_BLACK = FastColor.ARGB32.m_13660_((int)255, (int)25, (int)25, (int)25);
    private static int calcLeft;
    private static int calcTop;
    private static int screenLeft;
    private static int screenRight;
    private static int screenBottom;
    private static int graphLeft;
    private static int graphRight;
    private static int graphTop;
    private static int graphBottom;
    private static int graphHeight;
    private static int graphWidth;
    private static float currentPhase;
    private static int cachedWindowWidth;
    private static int cachedWindowHeight;
    private static Font FONT;
    private static final ResourceLocation MANA_BAR_TEXTURE;
    private static final ResourceLocation MANA_BAR_FOREGROUND_TEXTURE;
    private static final ResourceLocation MANA_BAR_BACKGROUND_TEXTURE;
    private static final ResourceLocation SPELL_CONTAINER_CD_TEXTURE;
    private static final ResourceLocation RAGE_BAR_ICON;
    private static final ResourceLocation RAGE_BAR;
    private static final ResourceLocation RAGE_BAR_METER;
    private static final ResourceLocation calcSprite;

    private static void computeVariables() {
        calcLeft = cachedWindowWidth - 100 - (int)((float)cachedWindowWidth * 0.05f);
        calcTop = cachedWindowHeight - (int)((float)cachedWindowHeight * 0.15f);
        screenLeft = calcLeft + 7;
        int screenTop = calcTop + 8;
        screenRight = screenLeft + 86;
        screenBottom = screenTop + 37;
        graphLeft = screenLeft + 2;
        graphRight = screenRight - 2;
        graphTop = screenTop + 2;
        graphBottom = screenBottom - 2;
        graphHeight = graphBottom - graphTop;
        graphWidth = graphRight - graphLeft;
        float currentTick = ClientTickHandler.getClientTick();
        currentPhase = currentTick * 0.025f;
    }

    @SubscribeEvent
    public static void onRender(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (FONT == null) {
            FONT = mc.f_91062_;
        }
        if (ModGui.shouldSkipRender((Player)player)) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        GuiGraphics gui = event.getGuiGraphics();
        Window window = event.getWindow();
        cachedWindowWidth = window.m_85445_();
        cachedWindowHeight = window.m_85446_();
        if (player.m_21093_(itemStack -> itemStack.m_204117_(ModTags.Items.MAGIC_ITEMS))) {
            ModGui.renderManaBar(gui, (Player)player);
            if (mainHand.m_41720_() instanceof BaseMagicTome) {
                ModGui.renderSpellSelection(gui, (Player)player, mainHand);
                if (SpellCastingHandler.currentlyChannellingSpell((Player)player, mainHand)) {
                    float channelProgress = SpellCastingHandler.getChannellingProgress((Player)player, mainHand);
                    RadialProgressBarRenderer.renderProgressBar(mainHand, gui, ModGui.getPixelX((Double)BrutalityClientConfig.MANA_BAR_X.get()), ModGui.getPixelY((Double)BrutalityClientConfig.MANA_BAR_Y.get()), 0.0, channelProgress);
                }
            } else if (offHand.m_41720_() instanceof BaseMagicTome) {
                ModGui.renderSpellSelection(gui, (Player)player, offHand);
                if (SpellCastingHandler.currentlyChannellingSpell((Player)player, offHand)) {
                    float channelProgress = SpellCastingHandler.getChannellingProgress((Player)player, offHand);
                    RadialProgressBarRenderer.renderProgressBar(offHand, gui, ModGui.getPixelX((Double)BrutalityClientConfig.MANA_BAR_X.get()), ModGui.getPixelY((Double)BrutalityClientConfig.MANA_BAR_Y.get()), 0.0, channelProgress);
                }
            }
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(arg_0 -> ModGui.lambda$onRender$6(gui, (Player)player, arg_0));
    }

    private static void renderManaBar(GuiGraphics gui, Player player) {
        float manaValue = player.getCapability(BrutalityCapabilities.PLAYER_MANA_CAP).map(EntityCapabilities.PlayerManaCap::manaValue).orElse(Float.valueOf(0.0f)).floatValue();
        AttributeInstance maxMana = player.m_21051_((Attribute)ModAttributes.MAX_MANA.get());
        float manaPercent = maxMana != null ? manaValue / (float)maxMana.m_22135_() : 0.0f;
        manaPercent = Mth.m_14036_((float)manaPercent, (float)0.0f, (float)1.0f);
        int diameter = 70;
        int radius = diameter / 2;
        int manaBarX = ModGui.getPixelX((Double)BrutalityClientConfig.MANA_BAR_X.get());
        int manaBarY = ModGui.getPixelY((Double)BrutalityClientConfig.MANA_BAR_Y.get());
        int visibleHeight = (int)((float)diameter * manaPercent);
        int textureY = diameter - visibleHeight;
        gui.m_280163_(MANA_BAR_BACKGROUND_TEXTURE, manaBarX - radius, manaBarY - radius, 0.0f, 0.0f, diameter, diameter, diameter, diameter);
        if (visibleHeight > 0) {
            gui.m_280163_(MANA_BAR_TEXTURE, manaBarX - radius, manaBarY - radius + (diameter - visibleHeight), 0.0f, (float)textureY, diameter, visibleHeight, diameter, diameter);
        }
        gui.m_280163_(MANA_BAR_FOREGROUND_TEXTURE, manaBarX - radius, manaBarY - radius, 0.0f, 0.0f, diameter, diameter, diameter, diameter);
    }

    private static void renderSpellSelection(GuiGraphics gui, Player player, ItemStack tome) {
        List<SpellStorage.SpellEntry> spellEntries = SpellStorage.getSpells(tome);
        float angleOffset = 0.0f;
        int distanceFromCenter = 68;
        SpellStorage.SpellEntry selectedSpell = SpellStorage.getCurrentSpellEntry(tome);
        float containerDiameter = 48.0f;
        float iconDiameter = 36.0f;
        float baseMiniDiameter = 16.0f;
        float baseMiniRadius = 8.0f;
        float baseContainerRadius = 24.0f;
        float baseIconRadius = 18.0f;
        int centerX = ModGui.getPixelX((Double)BrutalityClientConfig.MANA_BAR_X.get());
        int centerY = ModGui.getPixelY((Double)BrutalityClientConfig.MANA_BAR_Y.get());
        for (SpellStorage.SpellEntry spellEntry : spellEntries) {
            boolean isSelected = selectedSpell != null && selectedSpell.spell() == spellEntry.spell() && selectedSpell.level() == spellEntry.level();
            int actualSpellLevel = IBrutalitySpell.getActualSpellLevel((Entity)player, spellEntry.spell(), spellEntry.level());
            String spellLevelString = String.valueOf(actualSpellLevel);
            int xComponent = Math.round((float)centerX + Mth.m_14089_((float)angleOffset) * (float)distanceFromCenter);
            int yComponent = Math.round((float)centerY + Mth.m_14031_((float)angleOffset) * (float)distanceFromCenter);
            gui.m_280168_().m_85836_();
            if (isSelected) {
                float scale = 1.5f;
                gui.m_280168_().m_252880_((float)xComponent, (float)yComponent, 0.0f);
                gui.m_280168_().m_85841_(scale, scale, 1.0f);
                gui.m_280168_().m_252880_((float)(-xComponent), (float)(-yComponent), 0.0f);
            }
            IBrutalitySpell.MagicSchool school = spellEntry.spell().getSchool();
            gui.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/gui/spells/" + school + "/spell_container/bg.png")), (int)((float)xComponent - 24.0f), (int)((float)yComponent - 24.0f), 0.0f, 0.0f, 48, 48, 48, 48);
            gui.m_280163_(spellEntry.spell().getIcon(), (int)((float)xComponent - 18.0f), (int)((float)yComponent - 18.0f), 0.0f, 0.0f, 36, 36, 36, 36);
            if (SpellCooldownTracker.isOnCooldown(player, spellEntry.spell())) {
                float progress = 1.0f - SpellCooldownTracker.getCooldownProgress(player, spellEntry.spell());
                int visibleHeight = Math.round(36.0f * progress);
                gui.m_280163_(SPELL_CONTAINER_CD_TEXTURE, (int)((float)xComponent - 18.0f), (int)((float)yComponent + (36.0f - (float)visibleHeight) - 18.0f), 0.0f, (float)(36 - visibleHeight), 36, visibleHeight, 36, 36);
            }
            if (isSelected && SpellCastingHandler.currentlyCastingContinuousSpell(player, tome)) {
                gui.m_280163_(SPELL_CONTAINER_CD_TEXTURE, (int)((float)xComponent - 18.0f), (int)((float)yComponent - 18.0f), 0.0f, 36.0f, 36, 36, 36, 36);
            }
            gui.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/gui/spells/" + school + "/spell_container/fg.png")), (int)((float)xComponent - 24.0f), (int)((float)yComponent - 24.0f), 0.0f, 0.0f, 48, 48, 48, 48);
            gui.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/gui/spells/" + school + "/spell_container/mini.png")), (int)((float)xComponent - 8.0f), (int)((float)yComponent - 18.0f - 4.0f), 0.0f, 0.0f, 16, 16, 16, 16);
            int textWidth = FONT.m_92895_(spellLevelString);
            float targetWidth = 8.0f;
            float textScale = Math.min(1.0f, targetWidth / (float)textWidth);
            Objects.requireNonNull(FONT);
            Objects.requireNonNull(FONT);
            float verticalOffset = (9.0f - 9.0f * textScale) / 2.0f;
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_((float)xComponent + 0.5f, (float)yComponent - 18.0f + verticalOffset, 0.0f);
            gui.m_280168_().m_85841_(textScale, textScale, 1.0f);
            gui.drawString(FONT, spellLevelString, (float)(-textWidth) / 2.0f, 0.0f, school == IBrutalitySpell.MagicSchool.CELESTIA ? GUI_BLACK : GUI_WHITE, true);
            gui.m_280168_().m_85849_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            gui.m_280168_().m_85849_();
            angleOffset += 0.7853982f;
        }
    }

    private static void renderRageBar(GuiGraphics gui, Player player) {
        AttributeInstance maxRage = player.m_21051_((Attribute)ModAttributes.MAX_RAGE.get());
        if (maxRage != null) {
            player.getCapability(BrutalityCapabilities.PLAYER_RAGE_CAP).ifPresent(cap -> {
                int x = ModGui.getPixelX(0.05f);
                int y = ModGui.getPixelY(0.95f);
                gui.m_280195_(RAGE_BAR, x, y, (int)maxRage.m_22135_() + 8, 20, 4, 10, 4, 10, 256, 256, 0, 0);
                if (cap.rageValue() > 0.0f && (double)cap.rageValue() <= maxRage.m_22135_()) {
                    gui.m_280195_(RAGE_BAR_METER, x + 3, y + 3, (int)cap.rageValue() + 4, 8, 1, 4, 2, 4, 256, 256, 3, 3);
                }
                gui.m_280398_(RAGE_BAR_ICON, x - 16, y - 18, 1, 0.0f, 0.0f, 32, 36, 32, 36);
            });
        }
    }

    private static void renderSumDamageStored(GuiGraphics gui, SlotResult slot) {
        float damageStored = slot.stack().m_41784_().m_128457_(Sum.SUM_DAMAGE);
        String string = String.format("%.2f", Float.valueOf(damageStored));
        int n = screenLeft + FONT.m_92895_("15") + 2;
        Objects.requireNonNull(FONT);
        gui.m_280137_(FONT, string, n, screenBottom - 9 - 2, SCREEN_COLOR);
    }

    private static void renderComboCount(GuiGraphics gui, Player player) {
        player.getCapability(BrutalityCapabilities.PLAYER_COMBO_CAP).ifPresent(cap -> {
            String string = String.valueOf(cap.hitCount());
            int n = screenRight - FONT.m_92895_("15") - 2;
            Objects.requireNonNull(FONT);
            gui.m_280137_(FONT, string, n, screenBottom - 9 - 2, SCREEN_COLOR);
        });
    }

    private static void renderAxesAndTexture(GuiGraphics gui) {
        gui.m_280163_(calcSprite, calcLeft, calcTop, 0.0f, 0.0f, 100, 144, 100, 144);
        int centerX = graphLeft + graphWidth / 2;
        gui.m_280656_(graphLeft, graphRight, graphTop + graphHeight / 2, SCREEN_COLOR);
        gui.m_280315_(centerX, graphTop - 1, graphBottom, SCREEN_COLOR);
    }

    private static void renderSineWave(GuiGraphics gui) {
        for (int i = 0; i < graphWidth; ++i) {
            float relativeX = ((float)i - (float)graphWidth / 2.0f) / (float)graphWidth * ((float)Math.PI * 2);
            float value = Mth.m_14031_((float)(currentPhase + relativeX)) * 3.75f * 0.75f;
            float mappedY = ModGui.mapValueToY(value + 1.875f, -5.0f, 5.0f, graphHeight);
            int y = graphBottom - (int)mappedY - 1;
            gui.m_280509_(graphLeft + i, y, graphLeft + i + 1, y + 1, SINE_COLOR);
        }
    }

    private static void renderCosineWave(GuiGraphics gui) {
        for (int i = 0; i < graphWidth; ++i) {
            float relativeX = ((float)i - (float)graphWidth / 2.0f) / (float)graphWidth * ((float)Math.PI * 2);
            float value = Mth.m_14089_((float)(currentPhase + relativeX)) * 0.75f * 0.75f;
            float mappedY = ModGui.mapValueToY(value + 0.375f, -2.5f, 2.5f, graphHeight);
            int y = graphBottom - (int)mappedY;
            gui.m_280509_(graphLeft + i, y, graphLeft + i + 1, y + 1, COSINE_COLOR);
        }
    }

    private static float mapValueToY(float value, float min, float max, int height) {
        return (value - min) / (max - min) * (float)height;
    }

    private static boolean shouldSkipRender(Player player) {
        return player == null || Minecraft.m_91087_().f_91066_.f_92062_ || Minecraft.m_91087_().f_91080_ != null;
    }

    private static int getPixelX(double percentX) {
        return Math.round((float)((double)cachedWindowWidth * percentX));
    }

    private static int getPixelY(double percentY) {
        return Math.round((float)((double)cachedWindowHeight * percentY));
    }

    private static /* synthetic */ void lambda$onRender$6(GuiGraphics gui, Player player, ICuriosItemHandler handler) {
        if (handler.isEquipped((Item)BrutalityModItems.SCIENTIFIC_CALCULATOR.get())) {
            ModGui.computeVariables();
            ModGui.renderAxesAndTexture(gui);
            handler.findFirstCurio((Item)BrutalityModItems.SUM_CHARM.get()).ifPresent(slot -> ModGui.renderSumDamageStored(gui, slot));
            handler.findFirstCurio((Item)BrutalityModItems.EXPONENTIAL_CHARM.get()).ifPresent(slot -> ModGui.renderComboCount(gui, player));
            handler.findFirstCurio((Item)BrutalityModItems.SINE_CHARM.get()).ifPresent(slot -> ModGui.renderSineWave(gui));
            handler.findFirstCurio((Item)BrutalityModItems.COSINE_CHARM.get()).ifPresent(slot -> ModGui.renderCosineWave(gui));
        }
        if (!handler.findCurios(stack -> stack.m_204117_(ModTags.Items.RAGE_ITEMS)).isEmpty()) {
            ModGui.renderRageBar(gui, player);
        }
    }

    static {
        MANA_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/mana_bar.png");
        MANA_BAR_FOREGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/mana_bar_fg.png");
        MANA_BAR_BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/mana_bar_bg.png");
        SPELL_CONTAINER_CD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/spell_container_cd.png");
        RAGE_BAR_ICON = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/rage_bar_icon.png");
        RAGE_BAR = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/rage_bar.png");
        RAGE_BAR_METER = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/rage_bar_meter.png");
        calcSprite = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"textures/gui/scientific_calculator.png");
    }
}

