/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.base;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import net.goo.brutality.event.mod.client.BrutalityModItemRenderManager;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;

public class BrutalityHammerItem
extends TieredItem
implements BrutalityGeoItem {
    public String identifier;
    public Rarity rarity;
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    protected List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents;
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BrutalityHammerItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, new Item.Properties().m_41503_(1561));
        this.attackDamage = (float)pAttackDamageModifier + pTier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ModAttributes.STUN_CHANCE.get()), (Object)new AttributeModifier(BASE_STUN_CHANCE_UUID, "Weapon modifier", 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.defaultModifiers = builder.build();
        this.rarity = rarity;
        this.descriptionComponents = descriptionComponents;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return this.rarity;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        return this.brutalityNameHandler(pStack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        this.brutalityTooltipHandler(pStack, pTooltipComponents, this.descriptionComponents, this.rarity);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return BrutalityModItemRenderManager.createRenderer(BrutalityHammerItem.this);
            }
        });
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.BLUNT;
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.ItemType.HAMMER;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public boolean m_7579_(ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(@NotNull ItemStack pStack, @NotNull Level pLevel, BlockState pState, @NotNull BlockPos pPos, @NotNull LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(2, pEntityLiving, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

