/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.base;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import net.goo.brutality.client.ClientAccess;
import net.goo.brutality.event.mod.client.BrutalityModItemRenderManager;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.SealUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;

public class BrutalityThrowingItem
extends Item
implements BrutalityGeoItem {
    protected Rarity rarity;
    protected List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BrutalityThrowingItem(int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(new Item.Properties());
        this.rarity = rarity;
        this.descriptionComponents = descriptionComponents;
        float attackDamage = pAttackDamageModifier;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void handleThrowPacket(ItemStack stack, Player player) {
        Level level;
        EntityType<? extends Projectile> entityType = this.getThrownEntity();
        Projectile projectile = (Projectile)entityType.m_20615_(level = player.m_9236_());
        if (projectile != null) {
            projectile.m_146884_(player.m_146892_());
            projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowVelocity(player), this.getThrowInaccuracy());
            projectile.m_5602_((Entity)player);
            this.handleSealType(projectile, stack);
            level.m_7967_((Entity)projectile);
        }
    }

    protected void handleSealType(Projectile projectile, ItemStack stack) {
        SealUtils.SEAL_TYPE sealType = SealUtils.getSealType(stack);
        if (sealType != null) {
            projectile.getCapability(BrutalityCapabilities.SEAL_TYPE_CAP).ifPresent(cap -> cap.setSealType(sealType));
        }
    }

    public ResourceLocation getAnimationResourceLocation() {
        return THROW_ANIMATION.SWING.getAnimationResource();
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return this.rarity;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return BrutalityModItemRenderManager.createRenderer(BrutalityThrowingItem.this);
            }
        });
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.SLASH;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @NotNull
    public Component m_7626_(ItemStack pStack) {
        return this.brutalityNameHandler(pStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        this.brutalityTooltipHandler(pStack, pTooltipComponents, this.descriptionComponents, this.rarity);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public EntityType<? extends Projectile> getThrownEntity() {
        return EntityType.f_20548_;
    }

    public float getInitialThrowVelocity() {
        return 1.0f;
    }

    public float getThrowVelocity(Player player) {
        return (float)((double)this.getInitialThrowVelocity() * player.m_21133_((Attribute)ModAttributes.THROW_STRENGTH.get()));
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return true;
    }

    public float getThrowInaccuracy() {
        return 0.0f;
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.ItemType.THROWING;
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void handleAttributesAndAnimation(Player player, ItemStack stack, boolean isOffhand) {
        ClientAccess.ThrowableWeaponHelper.handleAttributesAndAnimation(player, this, stack, isOffhand);
    }

    public void handleCooldownAndSound(Player player, ItemStack stack) {
        ClientAccess.ThrowableWeaponHelper.handleCooldownAndSound(player, stack, this);
    }

    protected static enum THROW_ANIMATION {
        SWING(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"throw_swing")),
        DROP(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"throw_drop"));

        private final ResourceLocation animation;

        private THROW_ANIMATION(ResourceLocation animation) {
            this.animation = animation;
        }

        public ResourceLocation getAnimationResource() {
            return this.animation;
        }
    }
}

