/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.base;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import net.goo.brutality.event.mod.client.BrutalityModItemRenderManager;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;

public class BrutalityTridentItem
extends TridentItem
implements BrutalityGeoItem {
    protected String identifier;
    protected Rarity rarity;
    protected List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BrutalityTridentItem(float attackDamageModifier, float attackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(new Item.Properties().m_41499_(1561));
        ImmutableMultimap.Builder attributes = ImmutableMultimap.builder();
        attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)attackDamageModifier, AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = attributes.build();
        this.rarity = rarity;
        this.descriptionComponents = descriptionComponents;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return BrutalityModItemRenderManager.createRenderer(BrutalityTridentItem.this);
            }
        });
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.PIERCE;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return this.rarity;
    }

    @NotNull
    public Component m_7626_(ItemStack pStack) {
        return this.brutalityNameHandler(pStack);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        this.brutalityTooltipHandler(pStack, pTooltipComponents, this.descriptionComponents, this.rarity);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.ItemType.TRIDENT;
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    public boolean isRiptideEnabled() {
        return true;
    }

    public float getLaunchVel() {
        return 2.5f;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            int j;
            Player player = (Player)pEntityLiving;
            int i = this.m_8105_(pStack) - pTimeLeft;
            if (i >= 10 && ((j = net.minecraft.world.item.enchantment.EnchantmentHelper.m_44932_((ItemStack)pStack)) <= 0 || player.m_20070_())) {
                if (!pLevel.f_46443_) {
                    pStack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                    this.launchProjectile(pLevel, player, pStack);
                    if (!(player.m_150110_().f_35937_ || EnchantmentHelper.hasInfinity(pStack) || this.isInnatelyInfinite())) {
                        if (pStack.m_41613_() > 1) {
                            pStack.m_41774_(1);
                        } else {
                            player.m_150109_().m_36057_(pStack);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (j > 0) {
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        float f6 = 1.1999999f;
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, (double)f6, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    pLevel.m_6269_(null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    protected boolean isInnatelyInfinite() {
        return false;
    }

    public void launchProjectile(Level pLevel, Player player, ItemStack pStack) {
        int j = net.minecraft.world.item.enchantment.EnchantmentHelper.m_44932_((ItemStack)pStack);
        if (j == 0) {
            ThrownTrident thrownEntity = new ThrownTrident(pLevel, (LivingEntity)player, pStack);
            thrownEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getLaunchVel() + (float)j * 0.5f, 1.0f);
            if (player.m_150110_().f_35937_) {
                thrownEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            pLevel.m_7967_((Entity)thrownEntity);
            pLevel.m_6269_(null, (Entity)thrownEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

