/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.anklet;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityAnkletItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class CosmicAnklet
extends BrutalityAnkletItem {
    UUID COSMIC_ANKLET_DODGE_UUID = UUID.fromString("ba5102d9-bec7-497a-abf0-dd59ef799e2b");
    UUID COSMIC_ANKLET_GRAVITY_UUID = UUID.fromString("2aa5df84-b02d-476d-92c9-73f912472e8d");

    public CosmicAnklet(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.ANKLET;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)((Attribute)ModAttributes.DODGE_CHANCE.get()), (Object)new AttributeModifier(this.COSMIC_ANKLET_DODGE_UUID, "Dodge Buff", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_GRAVITY.get()), (Object)new AttributeModifier(this.COSMIC_ANKLET_GRAVITY_UUID, "Gravity Decrease", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

