/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.anklet;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityAnkletItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;

public class ExodiumAnklet
extends BrutalityAnkletItem {
    UUID EXODIUM_ANKLET_DODGE_UUID = UUID.fromString("623d1b0f-98f3-4010-87b6-91d09223687f");

    public ExodiumAnklet(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.ANKLET;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)((Attribute)ModAttributes.DODGE_CHANCE.get()), (Object)new AttributeModifier(this.EXODIUM_ANKLET_DODGE_UUID, "Dodge Buff", 0.15, AttributeModifier.Operation.MULTIPLY_BASE));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    @Override
    public void onDodgeServer(LivingEntity dodger, DamageSource source, float damage, ItemStack stack) {
        Player player;
        if (dodger instanceof Player && !(player = (Player)dodger).m_36335_().m_41519_((Item)this)) {
            ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(MobEffect::m_19486_).skip(dodger.m_217043_().m_216332_(0, ForgeRegistries.MOB_EFFECTS.getValues().size() - 1)).findFirst().ifPresent(effect -> {
                dodger.m_7292_(new MobEffectInstance(effect, 60, 0));
                player.m_36335_().m_41524_((Item)this, 40);
            });
        }
    }
}

