/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.SlotContext;

public class ConservativeConcoction
extends BrutalityCurioItem {
    UUID CONCOCTION_MANA_REGEN_UUID = UUID.fromString("6b9be152-d330-4b38-82ad-6cebfc3e4f32");
    private static final Object2FloatOpenHashMap<UUID> OLD_BONUS_MAP = new Object2FloatOpenHashMap();

    public ConservativeConcoction(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    private static float getBonus(Player player) {
        LazyOptional cap = player.getCapability(BrutalityCapabilities.PLAYER_MANA_CAP);
        if (cap.isPresent()) {
            return ((EntityCapabilities.PlayerManaCap)cap.orElse(null)).getCurrentManaRatio(player);
        }
        return 0.0f;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_() && player.f_19797_ % 10 == 0) {
            player.getCapability(BrutalityCapabilities.PLAYER_MANA_CAP).ifPresent(cap -> {
                AttributeInstance manaRegen = player.m_21051_((Attribute)ModAttributes.MANA_REGEN.get());
                UUID uuid = player.m_20148_();
                if (manaRegen != null) {
                    float newBonus = ConservativeConcoction.getBonus(player);
                    float oldBonus = OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f);
                    if ((double)Math.abs(oldBonus - newBonus) > 1.0E-4) {
                        OLD_BONUS_MAP.put((Object)uuid, newBonus);
                        manaRegen.m_22120_(this.CONCOCTION_MANA_REGEN_UUID);
                        manaRegen.m_22118_(new AttributeModifier(this.CONCOCTION_MANA_REGEN_UUID, "Mana Regen Bonus", (double)newBonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            });
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            builder.put((Object)((Attribute)ModAttributes.MANA_REGEN.get()), (Object)new AttributeModifier(this.CONCOCTION_MANA_REGEN_UUID, "Mana Regen Bonus", (double)ConservativeConcoction.getBonus(player), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return builder.build();
    }
}

