/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class Envy
extends BrutalityCurioItem {
    private static final UUID ENVY_HP_UUID = UUID.fromString("0a98b1be-25b9-4c38-8e4e-762979e8a1a3");
    private static final Object2FloatOpenHashMap<UUID> OLD_BONUS_MAP = new Object2FloatOpenHashMap();

    public Envy(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    private static float getNewBonus(LivingEntity wearer) {
        Player nearestValidPlayer = wearer.m_9236_().m_5788_(wearer.m_20185_(), wearer.m_20186_(), wearer.m_20189_(), 10.0, e -> {
            Player p;
            return e instanceof Player && !(p = (Player)e).m_7500_() && !p.m_5833_() && p != wearer && CuriosApi.getCuriosInventory((LivingEntity)p).map(handler -> handler.isEquipped((Item)BrutalityModItems.ENVY_CHARM.get())).orElse(false) == false;
        });
        if (nearestValidPlayer == null) {
            return 0.0f;
        }
        AttributeInstance maxHealthAttr = wearer.m_21051_(Attributes.f_22276_);
        float playerHealthNoEnvy = (float)wearer.m_21172_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            for (AttributeModifier modifier : maxHealthAttr.m_22122_()) {
                if (modifier.m_22209_().equals(ENVY_HP_UUID)) continue;
                playerHealthNoEnvy += (float)modifier.m_22218_();
            }
        }
        return Math.max((nearestValidPlayer.m_21233_() - playerHealthNoEnvy) / 2.0f, 0.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance maxHealth = livingEntity.m_21051_(Attributes.f_22276_);
            float newBonus = Envy.getNewBonus(livingEntity);
            UUID uuid = livingEntity.m_20148_();
            float oldBonus = OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f);
            if (maxHealth != null && oldBonus != newBonus) {
                OLD_BONUS_MAP.put((Object)uuid, newBonus);
                maxHealth.m_22120_(ENVY_HP_UUID);
                maxHealth.m_22118_(new AttributeModifier(ENVY_HP_UUID, "HP Bonus", (double)newBonus, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(ENVY_HP_UUID, "HP Buff", (double)Envy.getNewBonus(slotContext.entity()), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

