/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class Wrath
extends BrutalityCurioItem {
    UUID WRATH_RAGE_UUID = UUID.fromString("2d029ff6-aae3-424f-950e-5cd68a96d6c0");
    UUID WRATH_RAGE_TIME_UUID = UUID.fromString("e6f8b7ec-d379-403d-8cb6-7e51a15dca09");
    UUID WRATH_RAGE_GAIN_UUID = UUID.fromString("7d91e73a-6d7a-4576-8dfe-845898a6c63b");

    public Wrath(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)((Attribute)ModAttributes.MAX_RAGE.get()), (Object)new AttributeModifier(this.WRATH_RAGE_UUID, "Max Rage Buff", 50.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ModAttributes.RAGE_TIME_MULTIPLIER.get()), (Object)new AttributeModifier(this.WRATH_RAGE_TIME_UUID, "Max Rage Time Buff", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get()), (Object)new AttributeModifier(this.WRATH_RAGE_GAIN_UUID, "Rage Gain Buff", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        AttributeInstance rageGain;
        AttributeInstance rageTime;
        AttributeInstance maxRage = slotContext.entity().m_21051_((Attribute)ModAttributes.MAX_RAGE.get());
        if (maxRage != null) {
            maxRage.m_22120_(this.WRATH_RAGE_UUID);
        }
        if ((rageTime = slotContext.entity().m_21051_((Attribute)ModAttributes.RAGE_TIME_MULTIPLIER.get())) != null) {
            rageTime.m_22120_(this.WRATH_RAGE_TIME_UUID);
        }
        if ((rageGain = slotContext.entity().m_21051_((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get())) != null) {
            rageGain.m_22120_(this.WRATH_RAGE_GAIN_UUID);
        }
    }
}

