/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.heart;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class RuneOfDelta
extends BrutalityCurioItem {
    UUID RUNE_OF_DELTA_MAX_MANA_UUID = UUID.fromString("0ffa85eb-7b38-4ce6-b63e-b4cc74add07f");
    UUID RUNE_OF_DELTA_MANA_REGEN_UUID = UUID.fromString("fc619072-277b-4cc2-b70d-57a37397005c");
    private static final Object2IntOpenHashMap<UUID> OLD_BONUS_MAP = new Object2IntOpenHashMap();

    public RuneOfDelta(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.HEART;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance manaRegen = livingEntity.m_21051_((Attribute)ModAttributes.MANA_REGEN.get());
            int lightLevel = slotContext.entity().m_9236_().m_46803_(slotContext.entity().m_20097_().m_7494_());
            int newBonus = Math.max(0, 7 - lightLevel);
            UUID uuid = livingEntity.m_20148_();
            int oldBonus = OLD_BONUS_MAP.getOrDefault((Object)uuid, 0);
            if (manaRegen != null && oldBonus != newBonus) {
                OLD_BONUS_MAP.put((Object)uuid, newBonus);
                manaRegen.m_22120_(this.RUNE_OF_DELTA_MANA_REGEN_UUID);
                if (newBonus > 0) {
                    manaRegen.m_22118_(new AttributeModifier(this.RUNE_OF_DELTA_MANA_REGEN_UUID, "Mana Regen Bonus", (double)newBonus, AttributeModifier.Operation.ADDITION));
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeInt((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        int lightLevel;
        int bonus;
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)((Attribute)ModAttributes.MAX_MANA.get()), (Object)new AttributeModifier(this.RUNE_OF_DELTA_MAX_MANA_UUID, "Max Mana Buff", 20.0, AttributeModifier.Operation.ADDITION));
        if (slotContext.entity() != null && (bonus = Math.max(0, 7 - (lightLevel = slotContext.entity().m_9236_().m_46803_(slotContext.entity().m_20097_().m_7494_())))) > 0) {
            builder.put((Object)((Attribute)ModAttributes.MANA_REGEN.get()), (Object)new AttributeModifier(this.RUNE_OF_DELTA_MANA_REGEN_UUID, "Mana Regen Buff", (double)bonus, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }
}

