/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.necklace;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class BlackMatterNecklace
extends BrutalityCurioItem {
    UUID BLACK_MATTER_NECKLACE_CRIT_CHANCE = UUID.fromString("c224324e-92fa-11f0-a121-325096b39f47");
    UUID BLACK_MATTER_NECKLACE_CRIT_DAMAGE = UUID.fromString("c22434d8-92fa-11f0-9246-325096b39f47");
    private static final Object2FloatOpenHashMap<UUID> OLD_ARMOR_MAP = new Object2FloatOpenHashMap();

    public BlackMatterNecklace(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.NECKLACE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance critChance = livingEntity.m_21051_((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get());
            AttributeInstance critDamage = livingEntity.m_21051_((Attribute)ModAttributes.CRITICAL_STRIKE_DAMAGE.get());
            UUID uuid = livingEntity.m_20148_();
            if (critChance != null & critDamage != null) {
                float newArmor = livingEntity.m_21230_();
                float oldArmor = OLD_ARMOR_MAP.getOrDefault((Object)uuid, 0.0f);
                if ((double)Math.abs(oldArmor - newArmor) > 1.0E-4) {
                    OLD_ARMOR_MAP.put((Object)uuid, newArmor);
                    critDamage.m_22120_(this.BLACK_MATTER_NECKLACE_CRIT_DAMAGE);
                    critChance.m_22120_(this.BLACK_MATTER_NECKLACE_CRIT_CHANCE);
                    critChance.m_22118_(new AttributeModifier(this.BLACK_MATTER_NECKLACE_CRIT_CHANCE, "Crit Chance Buff", (double)(newArmor * 0.02f), AttributeModifier.Operation.MULTIPLY_BASE));
                    critDamage.m_22118_(new AttributeModifier(this.BLACK_MATTER_NECKLACE_CRIT_DAMAGE, "Crit Damage Buff", (double)(newArmor * -0.01f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_ARMOR_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            LivingEntity livingEntity = slotContext.entity();
            float armor = livingEntity.m_21230_();
            builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get()), (Object)new AttributeModifier(this.BLACK_MATTER_NECKLACE_CRIT_CHANCE, "Crit Chance Buff", (double)(armor * 0.02f), AttributeModifier.Operation.MULTIPLY_BASE));
            builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_DAMAGE.get()), (Object)new AttributeModifier(this.BLACK_MATTER_NECKLACE_CRIT_DAMAGE, "Crit Damage Buff", (double)(armor * -0.01f), AttributeModifier.Operation.MULTIPLY_BASE));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

