/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.goo.brutality.entity.projectile.trident.ThrownKnife;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class KnifeBlockItem
extends BrutalityGenericItem {
    private final String CHEF = "chef";
    private final String CARVING = "carving";
    private final String BREAD = "bread";
    private final String CLEAVER = "cleaver";
    private final String FORK = "fork";
    private final String AXE = "axe";
    private static final Set<Enchantment> ALLOWED_ENCHANTMENTS = Set.of(Enchantments.f_44980_);

    public KnifeBlockItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128344_("chef", (byte)1);
        stack.m_41784_().m_128344_("carving", (byte)1);
        stack.m_41784_().m_128344_("bread", (byte)1);
        stack.m_41784_().m_128344_("cleaver", (byte)1);
        stack.m_41784_().m_128344_("fork", (byte)1);
        stack.m_41784_().m_128344_("axe", (byte)1);
        return stack;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.restrictEnchants(book, ALLOWED_ENCHANTMENTS);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ALLOWED_ENCHANTMENTS.contains(enchantment);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        HashSet<String> allKnives = new HashSet<String>(Arrays.asList("chef", "carving", "bread", "cleaver", "fork", "axe"));
        ArrayList<String> availableKnives = new ArrayList<String>();
        for (String knife : allKnives) {
            if (!stack.m_41784_().m_128441_(knife)) continue;
            availableKnives.add(knife);
        }
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (!availableKnives.isEmpty()) {
                String randomKnife = (String)availableKnives.get(pLevel.m_213780_().m_188503_(availableKnives.size()));
                this.triggerAnim((Entity)pPlayer, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "no_" + randomKnife, "no_" + randomKnife);
                stack.m_41784_().m_128473_(randomKnife);
                this.launchProjectile(pLevel, pPlayer, stack, randomKnife);
                pLevel.m_247517_(null, pPlayer.m_20097_(), (SoundEvent)BrutalityModSounds.KNIFE_BLOCK.get(), SoundSource.PLAYERS);
            } else {
                pPlayer.m_36335_().m_41524_(stack.m_41720_(), 30);
                pLevel.m_247517_(null, pPlayer.m_20097_(), SoundEvents.f_11797_, SoundSource.PLAYERS);
                for (String knife : allKnives) {
                    this.stopTriggeredAnim((Entity)pPlayer, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "no_" + knife, "no_" + knife);
                    stack.m_41784_().m_128344_(knife, (byte)1);
                }
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void launchProjectile(Level pLevel, Player player, ItemStack pStack, String knifeType) {
        ThrownKnife thrownKnife = new ThrownKnife(pLevel, (LivingEntity)player, pStack, (EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.THROWN_KNIFE_ENTITY.get()), knifeType);
        thrownKnife.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
        thrownKnife.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        pLevel.m_7967_((Entity)thrownKnife);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "no_chef", state -> null).triggerableAnim("no_chef", RawAnimation.begin().thenPlay("no_chef"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "no_carving", state -> null).triggerableAnim("no_carving", RawAnimation.begin().thenPlay("no_carving"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "no_bread", state -> null).triggerableAnim("no_bread", RawAnimation.begin().thenPlay("no_bread"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "no_cleaver", state -> null).triggerableAnim("no_cleaver", RawAnimation.begin().thenPlay("no_cleaver"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "no_fork", state -> null).triggerableAnim("no_fork", RawAnimation.begin().thenPlay("no_fork"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "no_axe", state -> null).triggerableAnim("no_axe", RawAnimation.begin().thenPlay("no_axe"))});
    }
}

