/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import java.util.Objects;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TheCloudItem
extends BrutalityGenericItem {
    private static final String DATA = "data";
    private static final String HEALTH = "health";
    private static final String HUNGER = "hunger";
    private static final String SATURATION = "saturation";
    private static final String OXYGEN = "oxygen";
    private static final String EFFECTS = "effects";

    public TheCloudItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.m_5776_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        float health = pPlayer.m_21223_();
        FoodData foodData = pPlayer.m_36324_();
        int hunger = foodData.m_38702_();
        float saturation = foodData.m_38722_();
        int oxygen = pPlayer.m_20146_();
        CompoundTag dataTag = new CompoundTag();
        dataTag.m_128350_(HEALTH, health);
        dataTag.m_128405_(HUNGER, hunger);
        dataTag.m_128350_(SATURATION, saturation);
        dataTag.m_128405_(OXYGEN, oxygen);
        ListTag effectsList = new ListTag();
        pPlayer.m_21220_().forEach(effect -> {
            CompoundTag effectTag = new CompoundTag();
            effectsList.add((Object)effect.m_19555_(effectTag));
        });
        ModUtils.setTextureIdx(stack, 1);
        if (!stack.m_41784_().m_128441_(DATA)) {
            dataTag.m_128365_(EFFECTS, (Tag)effectsList);
            stack.m_41700_(DATA, (Tag)dataTag);
        } else {
            ModUtils.removeTextureIdx(stack);
            CompoundTag itemData = stack.m_41784_().m_128469_(DATA);
            pPlayer.m_21153_(itemData.m_128457_(HEALTH));
            FoodData foodData1 = pPlayer.m_36324_();
            foodData1.m_38705_(itemData.m_128451_(HUNGER));
            foodData1.m_38717_(itemData.m_128457_(SATURATION));
            pPlayer.m_20301_(itemData.m_128451_(OXYGEN));
            ListTag itemEffects = itemData.m_128437_(EFFECTS, 10);
            pPlayer.m_21219_();
            itemEffects.forEach(tag -> pPlayer.m_7292_(Objects.requireNonNull(MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)tag)))));
            stack.m_41749_(DATA);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pStack.m_41784_().m_128441_(DATA)) {
            pTooltipComponents.add((Component)Component.m_237119_());
            CompoundTag itemData = pStack.m_41784_().m_128469_(DATA);
            MutableComponent health = Component.m_237113_((String)": %.1f".formatted(Float.valueOf(itemData.m_128457_(HEALTH))));
            MutableComponent oxygen = Component.m_237113_((String)": %.1f".formatted(Float.valueOf(itemData.m_128457_(OXYGEN))));
            MutableComponent saturation = Component.m_237113_((String)": %.1f".formatted(Float.valueOf(itemData.m_128457_(SATURATION))));
            MutableComponent hunger = Component.m_237113_((String)": %.1f".formatted(Float.valueOf(itemData.m_128457_(HUNGER))));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.the_cloud.stored_data"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.the_cloud.health").m_7220_((Component)health));
            pTooltipComponents.add((Component)Component.m_237115_((String)"effect.minecraft.hunger").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)hunger.m_130940_(ChatFormatting.WHITE)));
            pTooltipComponents.add((Component)Component.m_237115_((String)"effect.minecraft.saturation").m_130940_(ChatFormatting.GOLD).m_7220_((Component)saturation.m_130940_(ChatFormatting.WHITE)));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.the_cloud.oxygen").m_7220_((Component)oxygen));
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.the_cloud.active_effects"));
            ListTag itemEffects = itemData.m_128437_(EFFECTS, 10);
            itemEffects.forEach(tag -> {
                MobEffectInstance effectInstance = MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)tag));
                if (effectInstance == null) {
                    return;
                }
                MutableComponent tooltip = effectInstance.m_19544_().m_19482_().m_6879_().m_7220_((Component)this.effectData(effectInstance));
                pTooltipComponents.add((Component)tooltip);
            });
        }
    }

    private MutableComponent describeDuration(MobEffectInstance instance) {
        return Component.m_237113_((String)(instance.m_267577_() ? "\u221e" : instance.m_19557_() + " seconds"));
    }

    public MutableComponent effectData(MobEffectInstance instance) {
        MutableComponent amplifier = Component.m_237113_((String)(instance.m_19564_() > 0 ? String.valueOf(instance.m_19564_() + 1) : "")).m_130940_(ChatFormatting.GREEN);
        MutableComponent duration = Component.m_237113_((String)"\u231a: ").m_7220_((Component)this.describeDuration(instance)).m_130940_(ChatFormatting.BLUE);
        MutableComponent s = Component.m_237113_((String)" ").m_7220_((Component)amplifier).m_130946_(" | ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)duration);
        if (!instance.m_19572_()) {
            s = s.m_130946_(" | Particles: false");
        }
        if (!instance.m_19575_()) {
            s = s.m_130946_(" | Show Icon: false");
        }
        return s;
    }
}

