/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.hammer;

import java.util.List;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.entity.explosion.NuclearExplosion;
import net.goo.brutality.item.base.BrutalityHammerItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class AtomicJudgementHammer
extends BrutalityHammerItem {
    public AtomicJudgementHammer(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle"))).triggerableAnim("controller", RawAnimation.begin().thenPlay("attack"))});
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public static void doExplosion(Player player, Vec3 loc) {
        Level level = player.m_9236_();
        NuclearExplosion explosion = new NuclearExplosion(player.m_9236_(), (Entity)player, null, null, loc.f_82479_, loc.f_82480_, loc.f_82481_, 3.0f, false, (Boolean)BrutalityCommonConfig.ATOMIC_JUDGEMENT_GRIEFING.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        ModExplosionHelper.Server.explode(explosion, level, true);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        Vec3 viewVec = pLivingEntity.m_20252_(1.0f).m_82541_();
        int charge = this.m_8105_(pStack) - pTimeCharged;
        float powerForTime = AtomicJudgementHammer.getPowerForTime(charge);
        if (pLivingEntity.m_20096_()) {
            pLivingEntity.m_246865_(viewVec.m_82490_((double)(powerForTime * -3.0f)));
            if (pLivingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pLivingEntity;
                player.m_36335_().m_41524_(pStack.m_41720_(), (int)(powerForTime * 100.0f));
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)pLivingEntity));
            }
        }
        pStack.m_41622_((int)(powerForTime * 20.0f), pLivingEntity, livingEntity -> pLivingEntity.m_21190_(InteractionHand.MAIN_HAND));
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }
}

