/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.scythe;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalityScytheItem;
import net.goo.brutality.util.helpers.AttributeHelper;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FallenScythe
extends BrutalityScytheItem {
    public static String SOULS_HARVESTED = "souls_harvested";
    private final Style STYLE_DARK_GREEN = Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN);
    private static final int baseAttackDamage = 3;
    private static final int entityReachBonus = 2;
    private static final UUID FALLEN_SCYTHE_INTERACTION_RANGE_UUID = UUID.fromString("62ac22db-a357-4e06-95c1-14aaee5606e5");
    private static final UUID FALLEN_SCYTHE_AS_UUID = UUID.fromString("d8e8adf6-69e3-4301-ae1d-504d19a71c23");
    private static final UUID FALLEN_SCYTHE_AD_UUID = UUID.fromString("099633e3-3be1-4c17-ac63-ba5b4a85e900");
    private static final Set<Enchantment> ALLOWED_ENCHANTMENTS = Set.of(Enchantments.f_44982_, Enchantments.f_44962_, Enchantments.f_44986_);

    public FallenScythe(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return 2;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        ItemStack mainHandItem;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (mainHandItem = (player = (Player)entity).m_21205_()).m_41720_() instanceof FallenScythe) {
            int soulsHarvested = mainHandItem.m_41784_().m_128451_(SOULS_HARVESTED);
            mainHandItem.m_41784_().m_128405_(SOULS_HARVESTED, soulsHarvested + 1);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)(event.getEntity().m_20206_() / 2.0f), event.getEntity().m_20189_(), 2, 0.25, 0.25, 0.25, 0.0);
                serverLevel.m_5594_(null, event.getEntity().m_20097_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 4.0f, 1.0f);
            }
            float baseAttackDamage = 3.0f;
            float attackDamageBonus = FallenScythe.calculateAttackDamageBonus(soulsHarvested);
            float newAttackDamage = baseAttackDamage + attackDamageBonus;
            newAttackDamage = Math.min(newAttackDamage, 17.0f);
            float attackSpeedModifier = -3.0f;
            float attackSpeedBonus = FallenScythe.calculateAttackSpeedBonus(soulsHarvested);
            float newAttackSpeed = attackSpeedModifier + attackSpeedBonus;
            newAttackSpeed = Math.min(newAttackSpeed, -2.4f);
            AttributeHelper.replaceOrAddModifier(mainHandItem, Attributes.f_22281_, FALLEN_SCYTHE_AD_UUID, newAttackDamage, EquipmentSlot.MAINHAND, AttributeModifier.Operation.ADDITION);
            AttributeHelper.replaceOrAddModifier(mainHandItem, Attributes.f_22283_, FALLEN_SCYTHE_AS_UUID, newAttackSpeed, EquipmentSlot.MAINHAND, AttributeModifier.Operation.ADDITION);
            AttributeHelper.replaceOrAddModifier(mainHandItem, (Attribute)ForgeMod.ENTITY_REACH.get(), FALLEN_SCYTHE_INTERACTION_RANGE_UUID, 2.0, EquipmentSlot.MAINHAND, AttributeModifier.Operation.ADDITION);
        }
    }

    public static float calculateAttackDamageBonus(int soulsHarvested) {
        return (float)soulsHarvested / 500.0f * 15.0f;
    }

    public static float calculateAttackSpeedBonus(int soulsHarvested) {
        return (float)((double)soulsHarvested / 500.0 * 0.6);
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.restrictEnchants(book, ALLOWED_ENCHANTMENTS);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ALLOWED_ENCHANTMENTS.contains(enchantment);
    }
}

