/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import java.util.List;
import java.util.WeakHashMap;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.core.animation.AnimatableManager;

@Mod.EventBusSubscriber(modid="brutality")
public class DarkinBladeSword
extends BrutalitySwordItem {
    private static final WeakHashMap<ItemStack, DarkinBladeData> INSTANCE_DATA = new WeakHashMap();

    public DarkinBladeSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        DarkinBladeData data = INSTANCE_DATA.computeIfAbsent(stack, k -> new DarkinBladeData());
        if (isSelected) {
            if (data.passiveCD > 0) {
                --data.passiveCD;
            } else if (data.passiveCD == 0 && !data.soundPlayed) {
                level.m_5594_(null, entity.m_20097_(), (SoundEvent)BrutalityModSounds.DEATHBRINGER_STANCE_READY.get(), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)level.f_46441_, (float)0.75f, (float)1.0f));
                data.soundPlayed = true;
            }
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity pTarget, LivingEntity pAttacker) {
        DarkinBladeData data = INSTANCE_DATA.get(stack);
        if (data != null && data.passiveCD <= 0) {
            float damage = pTarget.m_21233_() * 0.05f;
            pTarget.f_19802_ = 0;
            pTarget.m_6469_(pAttacker.m_269291_().m_269104_((Entity)pAttacker, null), damage);
            pAttacker.m_5634_(damage);
            if (pAttacker instanceof Player) {
                Player player = (Player)pAttacker;
                player.m_9236_().m_5594_(null, player.m_20097_(), (SoundEvent)BrutalityModSounds.DEATHBRINGER_STANCE_HIT.get(), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)player.m_9236_().f_46441_, (float)0.75f, (float)1.0f));
            }
            data.passiveCD = 100;
            data.soundPlayed = false;
        }
        return super.m_7579_(stack, pTarget, pAttacker);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        entity.m_9236_().m_5594_(null, entity.m_20183_(), ModUtils.getRandomSound(BrutalityModSounds.DARKIN_BLADE), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)entity.m_9236_().m_213780_(), (float)0.5f, (float)1.25f));
        return super.onEntitySwing(stack, entity);
    }

    private static class DarkinBladeData {
        int passiveCD = 0;
        boolean soundPlayed = false;

        private DarkinBladeData() {
        }
    }
}

