/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.entity.projectile.generic.AbyssProjectile;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundShootProjectilePacket;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ProjectileHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MarianasTrenchSword
extends BrutalitySwordItem {
    UUID MARIANA_TRENCH_RANGE_UUID = UUID.fromString("f720b147-fc30-4066-9edf-a9da2ab75042");

    public MarianasTrenchSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(this.MARIANA_TRENCH_RANGE_UUID, "Reach bonus", 2.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.performMarianasTrenchAttack(stack, player);
        }
        return super.onEntitySwing(stack, entity);
    }

    public void performMarianasTrenchAttack(ItemStack stack, Player player) {
        Level level = player.m_9236_();
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        if (level.m_5776_()) {
            for (int i = 1; i <= 360; i += 45) {
                PacketHandler.sendToServer(new ServerboundShootProjectilePacket(BrutalityModEntities.ABYSS_PROJECTILE.getId(), 0.5f, false, 0.0f, i));
            }
        } else {
            for (int i = 1; i <= 360; i += 45) {
                ProjectileHelper.shootProjectile(() -> new AbyssProjectile((EntityType<? extends ThrowableProjectile>)((EntityType)BrutalityModEntities.ABYSS_PROJECTILE.get()), level), player, level, 0.5f, false, Float.valueOf(0.0f), i);
            }
        }
        player.m_36335_().m_41524_(stack.m_41720_(), 10);
    }
}

