/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.goo.brutality.entity.projectile.generic.SupernovaAsteroid;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SupernovaSword
extends BrutalitySwordItem {
    private final RandomSource random = RandomSource.m_216327_();
    int tickCount;

    public SupernovaSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41663_(Enchantments.f_44980_, 3);
        return stack;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Level level = pAttacker.m_9236_();
        this.causeStarburstExplosion(pTarget, (Player)pAttacker);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < pAttacker.m_9236_().f_46441_.m_188503_(50); ++i) {
                serverLevel.m_8767_((ParticleOptions)ModUtils.getRandomParticle(BrutalityModParticles.COSMIC_PARTICLE), pTarget.m_20185_(), pTarget.m_20186_() + (double)(pTarget.m_20206_() / 2.0f), pTarget.m_20189_(), 1, 0.0, 0.0, 0.0, 100.0);
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        ++this.tickCount;
        if (!pIsSelected & !pLevel.m_5776_()) {
            SupernovaSword.clearAsteroids((Player)pEntity, (ServerLevel)pLevel);
        }
    }

    public static Stream<SupernovaAsteroid> getAllAsteroidsOwnedBy(LivingEntity owner, ServerLevel level) {
        return StreamSupport.stream(level.m_8583_().spliterator(), false).filter(entity -> entity instanceof SupernovaAsteroid).map(SupernovaAsteroid.class::cast).filter(asteroid -> asteroid.m_19749_() == owner);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            Stream<SupernovaAsteroid> asteroids = SupernovaSword.getAllAsteroidsOwnedBy((LivingEntity)pPlayer, serverLevel);
            if (asteroids.findAny().isEmpty()) {
                for (int i = 1; i <= 6; ++i) {
                    int angleOffset = (int)Math.toRadians(60 * i);
                    SupernovaAsteroid meteor = new SupernovaAsteroid((EntityType<? extends ThrowableProjectile>)((EntityType)BrutalityModEntities.SUPERNOVA_ASTEROID.get()), pLevel, angleOffset);
                    meteor.m_5602_((Entity)pPlayer);
                    meteor.m_6034_(pPlayer.m_20185_(), pPlayer.m_20186_() + 2.0, pPlayer.m_20189_());
                    pLevel.m_7967_((Entity)meteor);
                }
                pPlayer.m_36335_().m_41524_(stack.m_41720_(), 40);
                stack.m_41622_(6, (LivingEntity)pPlayer, player -> pPlayer.m_21190_(pUsedHand));
            } else if (pPlayer.m_6047_()) {
                SupernovaSword.clearAsteroids(pPlayer, serverLevel);
            } else {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"item.brutality.supernova.asteroid_fail").m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private void causeStarburstExplosion(LivingEntity target, Player player) {
        player.m_9236_().m_5594_(null, target.m_20097_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        List nearbyEntities = target.m_9236_().m_45933_((Entity)target, target.m_20191_().m_82400_(5.0));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            entity.m_6469_(entity.m_269291_().m_269036_((Entity)player, entity), 10.0f);
        }
    }

    public static void clearAsteroids(Player player, ServerLevel level) {
        Stream<SupernovaAsteroid> asteroidStream = SupernovaSword.getAllAsteroidsOwnedBy((LivingEntity)player, level);
        asteroidStream.forEach(asteroid -> {
            if (asteroid != null) {
                asteroid.m_146870_();
            }
        });
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Level level;
            Player player = (Player)livingEntity;
            if (player.m_21023_((MobEffect)BrutalityModMobEffects.STUNNED.get())) {
                player.m_21195_((MobEffect)BrutalityModMobEffects.STUNNED.get());
            }
            if ((level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SupernovaSword.clearAsteroids(player, serverLevel);
            }
        }
    }

    @SubscribeEvent
    public void onChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            SupernovaSword.clearAsteroids(player, (ServerLevel)player.m_9236_());
        }
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            SupernovaSword.clearAsteroids(player, (ServerLevel)player.m_9236_());
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_9236_().m_5594_(null, player.m_20097_(), ModUtils.getRandomSound(BrutalityModSounds.SUPERNOVA), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)this.random, (float)0.8f, (float)1.0f));
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "swing");
            }
        }
        return super.onEntitySwing(stack, entity);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenPlay("idle"))).triggerableAnim("swing", RawAnimation.begin().thenPlay("swing")).triggerableAnim("stab", RawAnimation.begin().thenPlay("stab"))});
    }
}

