/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.throwing;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class StyrofoamCup
extends BrutalityThrowingItem {
    protected String[] types = new String[]{"", "_water"};
    private final Block block;

    public StyrofoamCup(int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents, Block block) {
        super(pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
        this.block = block;
    }

    @Override
    public ResourceLocation getAnimationResourceLocation() {
        return BrutalityThrowingItem.THROW_ANIMATION.DROP.getAnimationResource();
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.BLUNT;
    }

    @Override
    public EntityType<? extends Projectile> getThrownEntity() {
        return (EntityType)BrutalityModEntities.STYROFOAM_CUP.get();
    }

    @Override
    @NotNull
    public Component m_7626_(ItemStack pStack) {
        return Component.m_237115_((String)("item.brutality.styrofoam_cup" + this.types[ModUtils.getTextureIdx(pStack)]));
    }

    @Override
    public void handleThrowPacket(ItemStack stack, Player player) {
        Level level;
        EntityType<? extends Projectile> entityType = this.getThrownEntity();
        net.goo.brutality.entity.projectile.trident.physics_projectile.StyrofoamCup styrofoamCup = (net.goo.brutality.entity.projectile.trident.physics_projectile.StyrofoamCup)entityType.m_20615_(level = player.m_9236_());
        if (styrofoamCup != null) {
            styrofoamCup.m_146884_(player.m_146892_());
            styrofoamCup.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowVelocity(player), this.getThrowInaccuracy());
            styrofoamCup.m_5602_((Entity)player);
            this.handleSealType((Projectile)styrofoamCup, stack);
            styrofoamCup.setCupTypeIndex(ModUtils.getTextureIdx(stack));
            level.m_7967_((Entity)styrofoamCup);
        }
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack pStack) {
        return 32;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (ModUtils.getTextureIdx(stack) != 0) {
            return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        Player player;
        Player player2 = player = pEntityLiving instanceof Player ? (Player)pEntityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, pStack);
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                pStack.m_41774_(1);
            }
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        if (player == null || !player.m_150110_().f_35937_) {
            if (pStack.m_41619_()) {
                return stack;
            }
            if (player != null) {
                player.m_150109_().m_36054_(stack);
            }
        }
        pEntityLiving.m_146850_(GameEvent.f_223704_);
        return pStack;
    }

    @Override
    public float getInitialThrowVelocity() {
        return 1.0f;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        InteractionResult interactionresult = this.place(new BlockPlaceContext(pContext));
        if (!interactionresult.m_19077_() && this.m_41472_()) {
            InteractionResult result = this.m_7203_(pContext.m_43725_(), pContext.m_43723_(), pContext.m_43724_()).m_19089_();
            return result == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : result;
        }
        return interactionresult;
    }

    public InteractionResult place(BlockPlaceContext pContext) {
        if (!this.getBlock().m_245993_(pContext.m_43725_().m_246046_())) {
            return InteractionResult.FAIL;
        }
        if (!pContext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(pContext);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockplacecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockplacecontext.m_8083_();
        Level level = blockplacecontext.m_43725_();
        Player player = blockplacecontext.m_43723_();
        ItemStack itemstack = blockplacecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, level, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)pContext.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, pContext.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate1));
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Deprecated
    protected SoundEvent getPlaceSound(BlockState pState) {
        return pState.m_60827_().m_56777_();
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext pContext) {
        return pContext;
    }

    protected void updateCustomBlockEntityTag(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        StyrofoamCup.updateCustomBlockEntityTag(pLevel, pPlayer, pPos, pStack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext pContext) {
        BlockState blockstate = this.getBlock().m_5573_(pContext);
        return blockstate != null && this.canPlace(pContext, blockstate) ? blockstate : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pPos, Level pLevel, ItemStack pStack, BlockState pState) {
        BlockState blockstate = pState;
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null) {
            CompoundTag blockStateTag = compoundtag.m_128469_("BlockStateTag");
            StateDefinition statedefinition = pState.m_60734_().m_49965_();
            for (String s : blockStateTag.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = blockStateTag.m_128423_(s).m_7916_();
                blockstate = StyrofoamCup.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != pState) {
            pLevel.m_7731_(pPos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState pState, Property<T> pProperty, String pValueIdentifier) {
        return pProperty.m_6215_(pValueIdentifier).map(p_40592_ -> (BlockState)pState.m_61124_(pProperty, p_40592_)).orElse(pState);
    }

    protected boolean canPlace(BlockPlaceContext pContext, BlockState pState) {
        Player player = pContext.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.mustSurvive() || pState.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) && pContext.m_43725_().m_45752_(pState, pContext.m_8083_(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext pContext, BlockState pState) {
        return pContext.m_43725_().m_7731_(pContext.m_8083_(), pState, 11);
    }

    public static void updateCustomBlockEntityTag(Level pLevel, @Nullable Player pPlayer, BlockPos pPos, ItemStack pStack) {
        BlockEntity blockentity;
        CompoundTag compoundtag;
        MinecraftServer minecraftserver = pLevel.m_7654_();
        if (minecraftserver != null && (compoundtag = StyrofoamCup.getBlockEntityData(pStack)) != null && (blockentity = pLevel.m_7702_(pPos)) != null) {
            if (!(pLevel.f_46443_ || !blockentity.m_6326_() || pPlayer != null && pPlayer.m_36337_())) {
                return;
            }
            CompoundTag saveWithoutMetadata = blockentity.m_187482_();
            CompoundTag copied = saveWithoutMetadata.m_6426_();
            saveWithoutMetadata.m_128391_(compoundtag);
            if (!saveWithoutMetadata.equals((Object)copied)) {
                blockentity.m_142466_(saveWithoutMetadata);
                blockentity.m_6596_();
            }
        }
    }

    @NotNull
    public String m_5524_() {
        return this.getBlock().m_7705_();
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        this.getBlock().m_5871_(pStack, (BlockGetter)pLevel, pTooltip, pFlag);
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)this.getBlockRaw()).get();
    }

    private Block getBlockRaw() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> pBlockToItemMap, Item pItem) {
        pBlockToItemMap.put(this.getBlock(), pItem);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove(this.getBlock());
    }

    public boolean m_142095_() {
        return !(this.block instanceof ShulkerBoxBlock);
    }

    public void m_142023_(ItemEntity pItemEntity) {
        ItemStack itemstack;
        CompoundTag compoundtag;
        if (this.block instanceof ShulkerBoxBlock && (compoundtag = StyrofoamCup.getBlockEntityData(itemstack = pItemEntity.m_32055_())) != null && compoundtag.m_128425_("Items", 9)) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            ItemUtils.m_150952_((ItemEntity)pItemEntity, listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_));
        }
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack pStack) {
        return pStack.m_41737_("BlockEntityTag");
    }

    public static void setBlockEntityData(ItemStack pStack, BlockEntityType<?> pBlockEntityType, CompoundTag pBlockEntityData) {
        if (pBlockEntityData.m_128456_()) {
            pStack.m_41749_("BlockEntityTag");
        } else {
            BlockEntity.m_187468_((CompoundTag)pBlockEntityData, pBlockEntityType);
            pStack.m_41700_("BlockEntityTag", (Tag)pBlockEntityData);
        }
    }

    @NotNull
    public FeatureFlagSet m_245183_() {
        return this.getBlock().m_245183_();
    }
}

