/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.tome;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellCastingHandler;
import net.goo.brutality.magic.SpellStorage;
import net.goo.brutality.magic.SpellUtils;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.mcreator.terramity.init.TerramityModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BaseMagicTome
extends BrutalityGenericItem {
    public BaseMagicTome(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128379_("closed", true);
        return stack;
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.ItemType.TOME;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.NONE;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        SpellStorage.SpellEntry spellEntry = SpellStorage.getCurrentSpellEntry(stack);
        if (spellEntry == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        IBrutalitySpell spell = spellEntry.spell();
        int actualSpellLevel = IBrutalitySpell.getActualSpellLevel((Entity)player, spell, spellEntry.level());
        List<IBrutalitySpell.SpellCategory> categories = spell.getCategories();
        SpellCastingHandler.CastConditionResult initialCheck = SpellCastingHandler.checkAllConditions(player, spell, actualSpellLevel);
        if (!initialCheck.canCast()) {
            player.m_5661_(initialCheck.feedback(), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (categories.contains((Object)IBrutalitySpell.SpellCategory.CHANNELLING)) {
            player.m_6672_(hand);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                stack.m_41784_().m_128379_("closed", false);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BrutalityModSounds.TOME_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "book_controller", "close");
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "main_controller", "cast_channelling");
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (categories.contains((Object)IBrutalitySpell.SpellCategory.CONTINUOUS)) {
            if (SpellCastingHandler.startContinuousCast(player, stack, spell, actualSpellLevel)) {
                player.m_6672_(hand);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    stack.m_41784_().m_128379_("closed", false);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BrutalityModSounds.TOME_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "book_controller", "close");
                    this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "main_controller", "cast_continuous");
                }
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        } else if (categories.contains((Object)IBrutalitySpell.SpellCategory.INSTANT) && SpellCastingHandler.castInstantSpell(player, stack, spell, actualSpellLevel)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TerramityModSounds.TOMEUSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "book_controller", "close");
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "main_controller", "cast_instant");
                player.m_36335_().m_41524_((Item)this, 30);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int remainingTicks) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SpellStorage.SpellEntry spellEntry = SpellStorage.getCurrentSpellEntry(stack);
        if (spellEntry == null) {
            return;
        }
        IBrutalitySpell spell = spellEntry.spell();
        int spellLevel = IBrutalitySpell.getActualSpellLevel((Entity)player, spell, spellEntry.level());
        if (spell.getCategories().contains((Object)IBrutalitySpell.SpellCategory.CHANNELLING)) {
            if (SpellCastingHandler.castChannellingSpell(player, stack, spell, spellLevel, remainingTicks)) {
                player.m_21253_();
            }
        } else if (spell.getCategories().contains((Object)IBrutalitySpell.SpellCategory.CONTINUOUS)) {
            SpellCastingHandler.tickContinuousCast(player, stack, spell, spellLevel);
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int ticksUsed) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SpellStorage.SpellEntry spellEntry = SpellStorage.getCurrentSpellEntry(stack);
        if (spellEntry == null) {
            return;
        }
        IBrutalitySpell spell = spellEntry.spell();
        int spellLevel = IBrutalitySpell.getActualSpellLevel((Entity)player, spell, spellEntry.level());
        if (spell.getCategories().contains((Object)IBrutalitySpell.SpellCategory.CONTINUOUS)) {
            SpellCastingHandler.endContinuousCast(player, stack, spell, spellLevel);
        }
        if (!level.m_5776_()) {
            this.closeBook(player, stack);
            player.m_36335_().m_41524_((Item)this, 30);
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isSelected) {
        if (!isSelected && entity instanceof Player) {
            Player player = (Player)entity;
            this.tryCloseBook(player, stack);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        this.tryCloseBook(player, stack);
        return super.onDroppedByPlayer(stack, player);
    }

    public void closeBook(Player player, ItemStack stack) {
        Level level = player.m_9236_();
        SpellStorage.SpellEntry spellEntry = SpellStorage.getCurrentSpellEntry(stack);
        if (spellEntry != null) {
            spellEntry.spell().onEndCast(player, stack, IBrutalitySpell.getActualSpellLevel((Entity)player, spellEntry.spell(), spellEntry.level()));
        }
        if (!level.m_5776_()) {
            stack.m_41784_().m_128379_("closed", true);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)BrutalityModSounds.TOME_CLOSE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), "main_controller", "cast_channelling");
            this.stopTriggeredAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), "main_controller", "cast_continuous");
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), "book_controller", "close");
        }
    }

    public void tryCloseBook(Player player, ItemStack stack) {
        if (!stack.m_41784_().m_128471_("closed")) {
            this.closeBook(player, stack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (level != null && !level.m_5776_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        List<SpellStorage.SpellEntry> spells = SpellStorage.getSpells(stack);
        if (spells.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"spell.brutality.empty"));
            return;
        }
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)mc.f_91066_.f_92090_.getKey().m_84873_())) {
            for (SpellStorage.SpellEntry entry : spells) {
                IBrutalitySpell spell = entry.spell();
                String spellName = spell.getSpellName();
                int actualSpellLevel = IBrutalitySpell.getActualSpellLevel((Entity)mc.f_91074_, spell, entry.level());
                float manaCostReduction = (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.MANA_COST.get());
                float spellDamageMultiplier = (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.SPELL_DAMAGE.get());
                float spellCdReduction = 2.0f - (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.SPELL_COOLDOWN_REDUCTION.get());
                float castTimeReduction = 2.0f - (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.CAST_TIME_REDUCTION.get());
                boolean showDamageMulti = (spellDamageMultiplier += SpellUtils.getCurioDamageMultiplier((Entity)mc.f_91074_, spell, actualSpellLevel) - 1.0f) != 1.0f;
                boolean showManaReduct = manaCostReduction != 1.0f;
                boolean showCDReduct = (spellCdReduction += SpellUtils.getCurioCooldownMultiplier((Entity)mc.f_91074_, spell, actualSpellLevel) - 1.0f) != 1.0f;
                boolean showCastReduct = (castTimeReduction += SpellUtils.getCurioCastTimeMultiplier((Entity)mc.f_91074_, spell, actualSpellLevel) - 1.0f) != 1.0f;
                MutableComponent divider = Component.m_237113_((String)" | ").m_130940_(ChatFormatting.DARK_GRAY);
                float manaCost = IBrutalitySpell.getActualManaCost((Player)mc.f_91074_, spell, actualSpellLevel);
                float castTime = IBrutalitySpell.getActualCastTime((Player)mc.f_91074_, spell, actualSpellLevel);
                castTime /= 20.0f;
                float spellCooldown = IBrutalitySpell.getActualCooldown((Player)mc.f_91074_, spell, actualSpellLevel);
                spellCooldown /= 20.0f;
                float finalDamage = spell.getFinalDamage((Entity)mc.f_91074_, actualSpellLevel);
                int bonusLevel = actualSpellLevel - entry.level();
                MutableComponent spellType = Component.m_237113_((String)" \u00a78|\u00a7r ");
                spell.getCategories().forEach(category -> spellType.m_130946_(category.icon + " "));
                tooltip.add((Component)Component.m_237115_((String)("spell.brutality." + spellName)).m_130946_(" \u00a78|\u00a7r " + entry.level() + (String)(bonusLevel > 0 ? " + \u00a7l" + bonusLevel : "")).m_7220_((Component)spellType));
                for (int i = 1; i <= spell.getDescriptionCount(); ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("spell.brutality." + spellName + ".description." + i)));
                }
                if (finalDamage > 0.0f) {
                    String damageOperator = spell.getDamageLevelScaling() > 0.0f ? " + " : " - ";
                    tooltip.add((Component)Component.m_237113_((String)("\ud83d\udde1 \u00a78|\u00a76 " + (showDamageMulti ? "(" : "") + spell.getBaseDamage() + "\u00a7r \u2764\u00a76" + damageOperator + "(" + Mth.m_14154_((float)spell.getDamageLevelScaling()) + "\u00a7r \u2764\u00a76 * level)" + (String)(showDamageMulti ? ") * " + String.format("%.2f", Float.valueOf(spellDamageMultiplier)) : "") + " = \u00a72" + finalDamage + "\u00a7r \u2764")));
                }
                if (castTime > 0.0f) {
                    String castTimeOperator = spell.getCastTimeLevelScaling() > 0 ? " + " : " - ";
                    tooltip.add((Component)Component.m_237113_((String)("\ud83e\ude84 \u00a78|\u00a76 " + (showCastReduct ? "(" : "") + spell.getBaseCastTime() / 20 + "s" + castTimeOperator + "(" + Mth.m_14154_((float)((float)spell.getCastTimeLevelScaling() / 20.0f)) + "s * level)" + (String)(showCastReduct ? ") * " + String.format("%.2f", Float.valueOf(castTimeReduction)) : "") + " = \u00a72" + castTime + "s")));
                }
                String manaOperator = spell.getManaCostLevelScaling() > 0.0f ? " + " : " - ";
                tooltip.add((Component)Component.m_237113_((String)("\ud83d\udca7 \u00a78|\u00a76 " + (showManaReduct ? "(" : "") + spell.getBaseManaCost() + "\u00a7r \ud83d\udca7\u00a76" + manaOperator + "(" + Mth.m_14154_((float)spell.getManaCostLevelScaling()) + "\u00a7r \ud83d\udca7\u00a76 * level)" + (String)(showManaReduct ? ") * " + String.format("%.2f", Float.valueOf(manaCostReduction)) : "") + " = \u00a72" + manaCost + "\u00a7r \ud83d\udca7")));
                String cdOperator = spell.getCooldownLevelScaling() > 0 ? " + " : " - ";
                tooltip.add((Component)Component.m_237113_((String)("\u231b \u00a78|\u00a76 " + (showCDReduct ? "(" : "") + spell.getBaseCooldown() / 20 + "s" + cdOperator + "(" + Mth.m_14154_((float)((float)spell.getCooldownLevelScaling() / 20.0f)) + "s * level)" + (String)(showCDReduct ? ") * " + String.format("%.2f", Float.valueOf(spellCdReduction)) : "") + " = \u00a72" + spellCooldown + "s")));
                if (spell.getStatComponents() != null) {
                    for (BrutalityTooltipHelper.SpellStatComponent component : spell.getStatComponents()) {
                        MutableComponent finalComponent = BaseMagicTome.getMutableComponent((Player)mc.f_91074_, entry, component);
                        if (component.min() != null) {
                            finalComponent.m_7220_((Component)divider).m_7220_((Component)Component.m_237113_((String)("\u1d0d\u026a\u0274 " + BaseMagicTome.computeUnit(component.min().floatValue(), component.type()))).m_130940_(ChatFormatting.RED));
                        }
                        if (component.max() != null) {
                            finalComponent.m_7220_((Component)divider).m_7220_((Component)Component.m_237113_((String)("\u1d0d\u1d00x " + BaseMagicTome.computeUnit(component.max().floatValue(), component.type()))).m_130940_(ChatFormatting.GREEN));
                        }
                        tooltip.add((Component)finalComponent);
                    }
                }
                tooltip.add((Component)Component.m_237119_());
            }
        } else {
            SpellStorage.SpellEntry entry = SpellStorage.getCurrentSpellEntry(stack);
            if (entry == null) {
                return;
            }
            IBrutalitySpell spell = entry.spell();
            String spellName = spell.getSpellName();
            int actualSpellLevel = IBrutalitySpell.getActualSpellLevel((Entity)mc.f_91074_, spell, entry.level());
            float manaCostReduction = (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.MANA_COST.get());
            float spellDamageMultiplier = (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.SPELL_DAMAGE.get());
            float spellCdReduction = 2.0f - (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.SPELL_COOLDOWN_REDUCTION.get());
            float castTimeReduction = 2.0f - (float)mc.f_91074_.m_21133_((Attribute)ModAttributes.CAST_TIME_REDUCTION.get());
            boolean showDamageMulti = (spellDamageMultiplier += SpellUtils.getCurioDamageMultiplier((Entity)mc.f_91074_, spell, actualSpellLevel) - 1.0f) != 1.0f;
            boolean showManaReduct = manaCostReduction != 1.0f;
            boolean showCDReduct = (spellCdReduction += SpellUtils.getCurioCooldownMultiplier((Entity)mc.f_91074_, spell, actualSpellLevel) - 1.0f) != 1.0f;
            boolean showCastReduct = (castTimeReduction += SpellUtils.getCurioCastTimeMultiplier((Entity)mc.f_91074_, spell, actualSpellLevel) - 1.0f) != 1.0f;
            MutableComponent divider = Component.m_237113_((String)" | ").m_130940_(ChatFormatting.DARK_GRAY);
            float manaCost = IBrutalitySpell.getActualManaCost((Player)mc.f_91074_, spell, actualSpellLevel);
            float castTime = IBrutalitySpell.getActualCastTime((Player)mc.f_91074_, spell, actualSpellLevel);
            castTime /= 20.0f;
            float spellCooldown = IBrutalitySpell.getActualCooldown((Player)mc.f_91074_, spell, actualSpellLevel);
            spellCooldown /= 20.0f;
            float finalDamage = spell.getFinalDamage((Entity)mc.f_91074_, actualSpellLevel);
            int bonusLevel = actualSpellLevel - entry.level();
            MutableComponent spellType = Component.m_237113_((String)" \u00a78|\u00a7r ");
            spell.getCategories().forEach(category -> spellType.m_130946_(category.icon + " "));
            tooltip.add((Component)Component.m_237115_((String)("spell.brutality." + spellName)).m_130946_(" \u00a78|\u00a7r " + entry.level() + (String)(bonusLevel > 0 ? " + \u00a7l" + bonusLevel : "")).m_7220_((Component)spellType));
            for (int i = 1; i <= spell.getDescriptionCount(); ++i) {
                tooltip.add((Component)Component.m_237115_((String)("spell.brutality." + spellName + ".description." + i)));
            }
            if (finalDamage > 0.0f) {
                String damageOperator = spell.getDamageLevelScaling() > 0.0f ? " + " : " - ";
                tooltip.add((Component)Component.m_237113_((String)("\ud83d\udde1 \u00a78|\u00a76 " + (showDamageMulti ? "(" : "") + spell.getBaseDamage() + "\u00a7r \u2764\u00a76" + damageOperator + "(" + Mth.m_14154_((float)spell.getDamageLevelScaling()) + "\u00a7r \u2764\u00a76 * level)" + (String)(showDamageMulti ? ") * " + String.format("%.2f", Float.valueOf(spellDamageMultiplier)) : "") + " = \u00a72" + finalDamage + "\u00a7r \u2764")));
            }
            if (castTime > 0.0f) {
                String castTimeOperator = spell.getCastTimeLevelScaling() > 0 ? " + " : " - ";
                tooltip.add((Component)Component.m_237113_((String)("\ud83e\ude84 \u00a78|\u00a76 " + (showCastReduct ? "(" : "") + spell.getBaseCastTime() / 20 + "s" + castTimeOperator + "(" + Mth.m_14154_((float)((float)spell.getCastTimeLevelScaling() / 20.0f)) + "s * level)" + (String)(showCastReduct ? ") * " + String.format("%.2f", Float.valueOf(castTimeReduction)) : "") + " = \u00a72" + castTime + "s")));
            }
            String manaOperator = spell.getManaCostLevelScaling() > 0.0f ? " + " : " - ";
            tooltip.add((Component)Component.m_237113_((String)("\ud83d\udca7 \u00a78|\u00a76 " + (showManaReduct ? "(" : "") + spell.getBaseManaCost() + "\u00a7r \ud83d\udca7\u00a76" + manaOperator + "(" + Mth.m_14154_((float)spell.getManaCostLevelScaling()) + "\u00a7r \ud83d\udca7\u00a76 * level)" + (String)(showManaReduct ? ") * " + String.format("%.2f", Float.valueOf(manaCostReduction)) : "") + " = \u00a72" + manaCost + "\u00a7r \ud83d\udca7")));
            String cdOperator = spell.getCooldownLevelScaling() > 0 ? " + " : " - ";
            tooltip.add((Component)Component.m_237113_((String)("\u231b \u00a78|\u00a76 " + (showCDReduct ? "(" : "") + spell.getBaseCooldown() / 20 + "s" + cdOperator + "(" + Mth.m_14154_((float)((float)spell.getCooldownLevelScaling() / 20.0f)) + "s * level)" + (String)(showCDReduct ? ") * " + String.format("%.2f", Float.valueOf(spellCdReduction)) : "") + " = \u00a72" + spellCooldown + "s")));
            if (spell.getStatComponents() != null) {
                for (BrutalityTooltipHelper.SpellStatComponent component : spell.getStatComponents()) {
                    MutableComponent finalComponent = BaseMagicTome.getMutableComponent((Player)mc.f_91074_, entry, component);
                    if (component.min() != null) {
                        finalComponent.m_7220_((Component)divider).m_7220_((Component)Component.m_237113_((String)("\u1d0d\u026a\u0274 " + BaseMagicTome.computeUnit(component.min().floatValue(), component.type()))).m_130940_(ChatFormatting.RED));
                    }
                    if (component.max() != null) {
                        finalComponent.m_7220_((Component)divider).m_7220_((Component)Component.m_237113_((String)("\u1d0d\u1d00x " + BaseMagicTome.computeUnit(component.max().floatValue(), component.type()))).m_130940_(ChatFormatting.GREEN));
                    }
                    tooltip.add((Component)finalComponent);
                }
            }
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237113_((String)("\u00a78Spell " + (spells.indexOf(entry) + 1) + "/" + spells.size())));
            tooltip.add((Component)Component.m_237113_((String)"\u00a78Press ").m_7220_(mc.f_91066_.f_92090_.getKey().m_84875_()).m_130940_(ChatFormatting.GRAY).m_130946_(" \u00a78to view all Spells"));
        }
    }

    private static float computeUnit(float input, BrutalityTooltipHelper.SpellStatComponents type) {
        if (type.equals((Object)BrutalityTooltipHelper.SpellStatComponents.DURATION)) {
            return input / 20.0f;
        }
        if (type.unit.contains("\u2764")) {
            return input / 2.0f;
        }
        return input;
    }

    @NotNull
    private static MutableComponent getMutableComponent(Player player, SpellStorage.SpellEntry entry, BrutalityTooltipHelper.SpellStatComponent component) {
        boolean shouldReset;
        BrutalityTooltipHelper.SpellStatComponents type = component.type();
        String operand = component.levelDelta() > 0.0f ? " + " : " - ";
        float base = BaseMagicTome.computeUnit(component.base(), type);
        float levelDelta = BaseMagicTome.computeUnit(Mth.m_14154_((float)component.levelDelta()), type);
        float finalValue = BaseMagicTome.computeUnit(entry.spell().getFinalStat(IBrutalitySpell.getActualSpellLevel((Entity)player, entry.spell(), entry.level()), component), type);
        boolean bl = shouldReset = !type.equals((Object)BrutalityTooltipHelper.SpellStatComponents.DURATION) && !type.equals((Object)BrutalityTooltipHelper.SpellStatComponents.CHANCE);
        if (component.max() != null && component.min() != null) {
            finalValue = Mth.m_14036_((float)finalValue, (float)BaseMagicTome.computeUnit(component.min().floatValue(), type), (float)BaseMagicTome.computeUnit(component.max().floatValue(), type));
        } else if (component.max() != null) {
            finalValue = Math.min(finalValue, BaseMagicTome.computeUnit(component.max().floatValue(), type));
        } else if (component.min() != null) {
            finalValue = Math.max(finalValue, BaseMagicTome.computeUnit(component.min().floatValue(), type));
        }
        return Component.m_237113_((String)(type.icon + " \u00a78|\u00a76 " + base + (shouldReset ? "\u00a7r" : "") + type.unit + "\u00a76" + operand + "(" + levelDelta + (shouldReset ? "\u00a7r" : "") + type.unit + "\u00a76 * level) = \u00a72" + finalValue + (shouldReset ? "\u00a7r" : "") + type.unit));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main_controller", state -> PlayState.STOP).triggerableAnim("cast_instant", RawAnimation.begin().thenPlay("cast_instant")).triggerableAnim("cast_channelling", RawAnimation.begin().thenPlayAndHold("cast_channelling")).triggerableAnim("cast_continuous", RawAnimation.begin().thenPlayAndHold("cast_continuous"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "book_controller", state -> PlayState.STOP).triggerableAnim("close", RawAnimation.begin().thenPlayAndHold("close"))});
    }
}

