/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.tome;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.weapon.tome.BaseMagicTome;
import net.goo.brutality.magic.SpellStorage;
import net.goo.brutality.magic.spells.voidwalker.GraviticImplosionSpell;
import net.goo.brutality.magic.spells.voidwalker.SpatialRuptureSpell;
import net.goo.brutality.magic.spells.voidwalker.VoidWalkSpell;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class VoidTome
extends BaseMagicTome {
    UUID VOID_SCHOOL_BOOST_UUID = UUID.fromString("bd93de15-b184-4c3f-a000-ccae764754cd");

    public VoidTome(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        SpellStorage.addSpell(stack, new GraviticImplosionSpell(), 1);
        SpellStorage.addSpell(stack, new SpatialRuptureSpell(), 1);
        SpellStorage.addSpell(stack, new VoidWalkSpell(), 10);
        return stack;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(modifiers);
            builder.put((Object)((Attribute)ModAttributes.VOIDWALKER_SCHOOL_LEVEL.get()), (Object)new AttributeModifier(this.VOID_SCHOOL_BOOST_UUID, "Void School bonus", 1.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return modifiers;
    }
}

