/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.trident;

import java.util.List;
import java.util.Set;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.entity.projectile.trident.physics_projectile.BiomechReactor;
import net.goo.brutality.item.base.BrutalityTridentItem;
import net.goo.brutality.registry.BrutalityDamageTypes;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class BiomechReactorTrident
extends BrutalityTridentItem {
    protected final RandomSource random = RandomSource.m_216327_();
    private static final Set<Enchantment> ALLOWED_ENCHANTMENTS = Set.of();

    public BiomechReactorTrident(float attackDamageModifier, float attackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(attackDamageModifier, attackSpeedModifier, rarity, descriptionComponents);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public float getLaunchVel() {
        return 0.75f;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.restrictEnchants(book, ALLOWED_ENCHANTMENTS);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ALLOWED_ENCHANTMENTS.contains(enchantment);
    }

    @Override
    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        super.m_5551_(pStack, pLevel, pEntityLiving, pTimeLeft);
        int i = this.m_8105_(pStack) - pTimeLeft;
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            if (i >= 10) {
                player.m_36335_().m_41524_(pStack.m_41720_(), 50);
            }
        }
    }

    @Override
    public void launchProjectile(Level pLevel, Player player, ItemStack pStack) {
        BiomechReactor thrownEntity = new BiomechReactor((EntityType<? extends BrutalityAbstractThrowingProjectile>)((EntityType)BrutalityModEntities.BIOMECH_REACTOR.get()), player, pLevel, BrutalityDamageTypes.THROWING_BLUNT);
        thrownEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getLaunchVel(), 1.0f);
        pLevel.m_7967_((Entity)thrownEntity);
    }

    @Override
    protected boolean isInnatelyInfinite() {
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }
}

