/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.trident;

import java.util.List;
import java.util.Set;
import net.goo.brutality.entity.projectile.trident.ThrownGungnir;
import net.goo.brutality.item.base.BrutalityTridentItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GungnirTrident
extends BrutalityTridentItem {
    protected final RandomSource random = RandomSource.m_216327_();
    private static final Set<Enchantment> ALLOWED_ENCHANTMENTS = Set.of(Enchantments.f_44982_, Enchantments.f_44962_, Enchantments.f_44986_, Enchantments.f_44955_);

    public GungnirTrident(float attackDamageModifier, float attackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(attackDamageModifier, attackSpeedModifier, rarity, descriptionComponents);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41663_(Enchantments.f_44955_, 4);
        return stack;
    }

    @Override
    public float getLaunchVel() {
        return 1.75f;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.restrictEnchants(book, ALLOWED_ENCHANTMENTS);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ALLOWED_ENCHANTMENTS.contains(enchantment);
    }

    @Override
    public void launchProjectile(Level pLevel, Player player, ItemStack pStack) {
        ThrownGungnir thrownEntity = new ThrownGungnir(pLevel, (LivingEntity)player, pStack, (EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.THROWN_GUNGNIR_ENTITY.get()));
        thrownEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getLaunchVel(), 1.0f);
        if (player.m_150110_().f_35937_) {
            thrownEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        pLevel.m_7967_((Entity)thrownEntity);
        pLevel.m_6269_(null, (Entity)thrownEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_ && !EnchantmentHelper.hasInfinity(pStack)) {
            player.m_150109_().m_36057_(pStack);
        }
    }
}

