/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.trident;

import java.util.List;
import java.util.Set;
import net.goo.brutality.entity.projectile.trident.ThrownThunderbolt;
import net.goo.brutality.item.base.BrutalityTridentItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnchantmentHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class ThunderboltTrident
extends BrutalityTridentItem {
    protected final RandomSource random = RandomSource.m_216327_();
    private static final Set<Enchantment> ALLOWED_ENCHANTMENTS = Set.of(Enchantments.f_44982_, Enchantments.f_44962_, Enchantments.f_44986_, Enchantments.f_44955_, Enchantments.f_44952_);

    public ThunderboltTrident(float attackDamageModifier, float attackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(attackDamageModifier, attackSpeedModifier, rarity, descriptionComponents);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41663_(Enchantments.f_44952_, 1);
        stack.m_41663_(Enchantments.f_44955_, 5);
        return stack;
    }

    @Override
    public float getLaunchVel() {
        return 8.0f;
    }

    @Override
    public void launchProjectile(Level pLevel, Player player, ItemStack pStack) {
        int j = net.minecraft.world.item.enchantment.EnchantmentHelper.m_44932_((ItemStack)pStack);
        if (j == 0) {
            ThrownThunderbolt thrownThunderbolt = new ThrownThunderbolt(pLevel, (LivingEntity)player, pStack, (EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.THROWN_THUNDERBOLT_ENTITY.get()));
            thrownThunderbolt.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getLaunchVel() + (float)j * 0.5f, 1.0f);
            if (player.m_150110_().f_35937_) {
                thrownThunderbolt.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            pLevel.m_7967_((Entity)thrownThunderbolt);
            pLevel.m_6269_(null, (Entity)thrownThunderbolt, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_ && !EnchantmentHelper.hasInfinity(pStack)) {
                player.m_150109_().m_36057_(pStack);
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pPlayer.m_6144_()) {
            this.performZeusWrathAttack(pPlayer, pLevel, itemstack, pHand);
            pPlayer.m_36335_().m_41524_(itemstack.m_41720_(), 80);
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (net.minecraft.world.item.enchantment.EnchantmentHelper.m_44932_((ItemStack)itemstack) > 0 && !pPlayer.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void performZeusWrathAttack(Player pPlayer, Level pLevel, ItemStack pStack, InteractionHand pHand) {
        for (int i = 0; i < this.random.m_216339_(5, 11); ++i) {
            float distance = Mth.m_216267_((RandomSource)this.random, (float)5.0f, (float)10.0f);
            float angle = this.random.m_188501_() * 2.0f * (float)Math.PI;
            float xOffset = distance * (float)Math.cos(angle);
            float zOffset = distance * (float)Math.sin(angle);
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(pLevel);
            assert (lightningBolt != null);
            lightningBolt.m_6034_(pPlayer.m_20185_() + (double)xOffset, pPlayer.m_20186_(), pPlayer.m_20189_() + (double)zOffset);
            lightningBolt.m_20879_(pPlayer instanceof ServerPlayer ? (ServerPlayer)pPlayer : null);
            pLevel.m_7967_((Entity)lightningBolt);
            pStack.m_41622_(1, (LivingEntity)pPlayer, player -> pPlayer.m_21190_(pHand));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ALLOWED_ENCHANTMENTS.contains(enchantment);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.restrictEnchants(book, ALLOWED_ENCHANTMENTS);
    }
}

