/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.goo.brutality.magic.SpellUtils;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IBrutalitySpell {
    public static int getActualCooldown(Player player, IBrutalitySpell spell, int spellLevel) {
        float base = spell.getBaseCooldown() + spell.getCooldownLevelScaling() * spellLevel;
        return Math.max((int)((double)(base *= SpellUtils.getCurioCooldownMultiplier((Entity)player, spell, spellLevel)) * (2.0 - player.m_21133_((Attribute)ModAttributes.SPELL_COOLDOWN_REDUCTION.get()))), 1);
    }

    public static float getActualManaCost(Player player, IBrutalitySpell spell, int spellLevel) {
        float base = (float)spell.getBaseManaCost() + spell.getManaCostLevelScaling() * (float)spellLevel;
        return (float)Math.max((double)((int)base) * player.m_21133_((Attribute)ModAttributes.MANA_COST.get()), 1.0);
    }

    public static int getActualCastTime(Player player, IBrutalitySpell spell, int spellLevel) {
        float base = spell.getBaseCastTime() + spell.getCastTimeLevelScaling() * spellLevel;
        return Math.max((int)((double)(base *= SpellUtils.getCurioCastTimeMultiplier((Entity)player, spell, spellLevel)) * (2.0 - player.m_21133_((Attribute)ModAttributes.CAST_TIME_REDUCTION.get()))), 1);
    }

    public static int getActualSpellLevel(@Nullable Entity caster, IBrutalitySpell spell, int spellLevel) {
        MagicSchool school = spell.getSchool();
        if (caster == null) {
            return spellLevel;
        }
        if (caster instanceof LivingEntity) {
            LivingEntity livingCaster = (LivingEntity)caster;
            Attribute attribute = ModAttributes.getSpellSchoolAttributeMap().get((Object)school);
            AttributeInstance attributeInstance = livingCaster.m_21051_(attribute);
            if (attributeInstance != null) {
                return Math.max((int)((double)spellLevel + attributeInstance.m_22135_()), 0);
            }
            return Math.max(spellLevel, 0);
        }
        return spellLevel;
    }

    public int getBaseManaCost();

    default public float getManaCostLevelScaling() {
        return 0.0f;
    }

    public float getBaseDamage();

    default public float getDamageLevelScaling() {
        return 0.0f;
    }

    public int getBaseCooldown();

    default public int getCooldownLevelScaling() {
        return 0;
    }

    public int getBaseCastTime();

    default public int getCastTimeLevelScaling() {
        return 0;
    }

    public MagicSchool getSchool();

    public ResourceLocation getIcon();

    public List<SpellCategory> getCategories();

    public String getSpellName();

    public int getDescriptionCount();

    public List<BrutalityTooltipHelper.SpellStatComponent> getStatComponents();

    default public boolean onCastTick(Player player, ItemStack stack, int spellLevel) {
        return true;
    }

    default public boolean onStartCast(Player player, ItemStack stack, int spellLevel) {
        return true;
    }

    default public void onEndCast(Player player, ItemStack stack, int spellLevel) {
    }

    default public float getFinalDamage(@Nullable Entity caster, int spellLevel) {
        LivingEntity livingCaster;
        AttributeInstance spellDamage;
        float dmg = this.getBaseDamage() + this.getDamageLevelScaling() * (float)IBrutalitySpell.getActualSpellLevel(caster, this, spellLevel);
        dmg *= SpellUtils.getCurioDamageMultiplier(caster, null, spellLevel);
        if (caster instanceof LivingEntity && (spellDamage = (livingCaster = (LivingEntity)caster).m_21051_((Attribute)ModAttributes.SPELL_DAMAGE.get())) != null) {
            return (float)((double)dmg * spellDamage.m_22135_());
        }
        return dmg;
    }

    default public float getFinalStat(int spellLevel, BrutalityTooltipHelper.SpellStatComponent stat) {
        float value = stat.base() + stat.levelDelta() * (float)spellLevel;
        if (stat.max() != null && stat.min() != null) {
            return Mth.m_14036_((float)value, (float)stat.min().floatValue(), (float)stat.max().floatValue());
        }
        if (stat.max() != null) {
            return Math.min(value, stat.max().floatValue());
        }
        if (stat.min() != null) {
            return Math.max(value, stat.min().floatValue());
        }
        return value;
    }

    public static enum MagicSchool {
        DAEMONIC("daemonium"),
        DARKIST("dimlite"),
        EVERGREEN("virentium"),
        VOLTWEAVER("conductite"),
        COSMIC("cosmilite"),
        CELESTIA("reverium"),
        UMBRANCY("umbrancy"),
        EXODIC("exodium"),
        VOIDWALKER("void"),
        BRIMWIELDER("hellspec");

        private final String material;

        private MagicSchool(String material) {
            this.material = material;
        }

        public String getMaterial() {
            return this.material;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum SpellCategory {
        INSTANT("\u23ef"),
        CHANNELLING("\ud83d\udeb9"),
        CONTINUOUS("\u21ba"),
        TARGET("\ud83c\udfaf"),
        AOE("\u25ef"),
        SELF("\ud83e\uddcd"),
        BUFF("\u2b06"),
        DEBUFF("\u2b07"),
        UTILITY("\ud83d\udd27");

        public final String icon;

        private SpellCategory(String icon) {
            this.icon = icon;
        }
    }
}

