/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic.spells.brimwielder;

import java.util.Iterator;
import java.util.List;
import net.goo.brutality.entity.spells.brimwielder.BrimspikeEntity;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BrimspikeSpell
extends BrutalitySpell {
    public BrimspikeSpell() {
        super(IBrutalitySpell.MagicSchool.BRIMWIELDER, List.of(IBrutalitySpell.SpellCategory.CONTINUOUS, IBrutalitySpell.SpellCategory.AOE), "brimspike", 10, 1.0f, 100, 5, 1, List.of(new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.PIERCE, 1.0f, 0.0f, Float.valueOf(1.0f), Float.valueOf(1.0f))));
    }

    @Override
    public float getDamageLevelScaling() {
        return 0.5f;
    }

    @Override
    public float getManaCostLevelScaling() {
        return 0.25f;
    }

    @Override
    public int getCooldownLevelScaling() {
        return 5;
    }

    @Override
    public boolean onCastTick(Player player, ItemStack stack, int spellLevel) {
        Entity entity = this.getSpellEntity(player.m_9236_(), player);
        if (entity instanceof BrimspikeEntity) {
            BrimspikeEntity brimspikeEntity = (BrimspikeEntity)entity;
            Vec3 targetPos = player.m_146892_().m_82549_(player.m_20154_().m_82490_(5.0));
            Vec3 currentPos = brimspikeEntity.m_20182_();
            Vector3f newPos = currentPos.m_165921_(targetPos, 0.2).m_252839_();
            Vec3 movement = new Vec3(newPos).m_82546_(currentPos);
            brimspikeEntity.m_20256_(movement);
            String damage = String.format("%.2f", brimspikeEntity.m_36789_());
            player.m_5661_((Component)Component.m_237113_((String)damage), true);
        }
        return true;
    }

    @Override
    public boolean onStartCast(Player player, ItemStack stack, int spellLevel) {
        if (this.getSpellEntity(player.m_9236_(), player) == null) {
            BrimspikeEntity brimspikeEntity = new BrimspikeEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.BRIMSPIKE_ENTITY.get()), player.m_9236_());
            brimspikeEntity.m_5602_((Entity)player);
            brimspikeEntity.m_146884_(player.m_20154_().m_82490_(3.0).m_82520_(player.m_20185_(), player.m_20188_(), player.m_20189_()));
            brimspikeEntity.m_146922_((float)(1.5707963267948966 - (double)player.m_5675_(1.0f)));
            brimspikeEntity.m_146926_((float)(1.5707963267948966 - (double)player.m_5686_(1.0f)));
            brimspikeEntity.setSpellLevel(spellLevel);
            brimspikeEntity.m_20242_(true);
            player.m_9236_().m_7967_((Entity)brimspikeEntity);
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"spell.brutality.brimspike.fail"), true);
        return false;
    }

    @Override
    public void onEndCast(Player player, ItemStack stack, int spellLevel) {
        Entity entity = this.getSpellEntity(player.m_9236_(), player);
        if (entity instanceof BrimspikeEntity) {
            BrimspikeEntity brimspikeEntity = (BrimspikeEntity)entity;
            brimspikeEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, Math.min(3.5f, (float)(stack.m_41779_() - player.m_21212_()) / 40.0f), 0.0f);
        }
    }

    private Entity getSpellEntity(Level level, Player player) {
        Iterator iterator = level.m_6443_(BrimspikeEntity.class, player.m_20191_().m_82400_(25.0), e -> e.m_19749_() == player).iterator();
        if (iterator.hasNext()) {
            BrimspikeEntity entity = (BrimspikeEntity)iterator.next();
            return entity;
        }
        return null;
    }
}

