/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic.spells.cosmic;

import java.util.List;
import net.goo.brutality.entity.spells.cosmic.StarStreamEntity;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StarStreamSpell
extends BrutalitySpell {
    public StarStreamSpell() {
        super(IBrutalitySpell.MagicSchool.COSMIC, List.of(IBrutalitySpell.SpellCategory.CONTINUOUS, IBrutalitySpell.SpellCategory.TARGET), "star_stream", 8, 3.0f, 20, 10, 1, List.of(new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.SPEED, 1.0f, 0.25f, Float.valueOf(1.0f), Float.valueOf(3.0f))));
    }

    @Override
    public float getDamageLevelScaling() {
        return 0.25f;
    }

    @Override
    public int getCooldownLevelScaling() {
        return 2;
    }

    @Override
    public int getCastTimeLevelScaling() {
        return -1;
    }

    @Override
    public boolean onCastTick(Player player, ItemStack stack, int spellLevel) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            Vec3 target;
            ServerLevel serverLevel = (ServerLevel)level;
            ModUtils.RayData<Entity> rayData = ModUtils.getEntitiesInRay(Entity.class, (LivingEntity)player, 20.0f, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 0.5f, e -> e != player && !(e instanceof StarStreamEntity), 1, null);
            if (!rayData.entityList().isEmpty()) {
                Entity targetEntity = rayData.entityList().get(0);
                target = targetEntity.m_20182_().m_82520_(0.0, (double)(targetEntity.m_20206_() / 2.0f), 0.0);
            } else {
                BlockPos blockPos = ModUtils.getBlockLookingAt(player, false, 20.0f);
                target = blockPos == null ? player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(20.0)) : Vec3.m_82512_((Vec3i)blockPos);
            }
            StarStreamEntity spellEntity = new StarStreamEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.STAR_STREAM_ENTITY.get()), (Level)serverLevel);
            spellEntity.setSpellLevel(spellLevel);
            Vec3 randomPos = player.m_20182_().m_82520_(player.m_217043_().m_188583_() * 2.0, player.m_217043_().m_188500_() * 2.0 + 2.0, player.m_217043_().m_188583_() * 2.0);
            spellEntity.m_146884_(randomPos);
            spellEntity.m_5602_((Entity)player);
            float inaccuracy = (float)(5 - spellLevel) * 0.25f;
            target.m_82520_((double)Mth.m_216267_((RandomSource)player.m_217043_(), (float)(-inaccuracy), (float)inaccuracy), (double)Mth.m_216267_((RandomSource)player.m_217043_(), (float)(-inaccuracy), (float)inaccuracy), (double)Mth.m_216267_((RandomSource)player.m_217043_(), (float)(-inaccuracy), (float)inaccuracy));
            Vec3 direction = target.m_82546_(randomPos).m_82541_();
            spellEntity.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.SPEED)), Math.max(5 - spellLevel, 0));
            serverLevel.m_7967_((Entity)spellEntity);
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), (SoundEvent)BrutalityModSounds.BASS_BOP.get(), SoundSource.AMBIENT, 1.5f - (float)Math.min(spellLevel, 10) / 10.0f, Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.7f, (float)1.2f));
        }
        return true;
    }
}

