/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.lang.reflect.Method;
import net.goo.brutality.event.LivingDodgeEvent;
import net.goo.brutality.item.base.BrutalityAnkletItem;
import net.goo.brutality.item.weapon.scythe.DarkinScythe;
import net.goo.brutality.network.ClientboundDodgePacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.BrutalityEntityRotations;
import net.goo.brutality.util.ModUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements BrutalityEntityRotations {
    @Unique
    private static final float TIMEKEEPERS_CLOCK_DEBUFF_DURATION = 0.75f;
    @Unique
    private static final float TCOFT_DEBUFF_DURATION = 0.65f;
    @Unique
    private static final float TCOFT_BUFF_DURATION = 1.25f;
    @Unique
    public float brutality$prevRoll;
    @Unique
    public float brutality$roll;
    @Unique
    public float brutality$prevYaw;
    @Unique
    public float brutality$yaw;
    @Unique
    public float brutality$prevPitch;
    @Unique
    public float brutality$pitch;

    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @ModifyVariable(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private MobEffectInstance modifyEffectDuration(MobEffectInstance effectInstance) {
        LivingEntity entity = (LivingEntity)this;
        MobEffect effect = effectInstance.m_19544_();
        int originalDuration = effectInstance.m_19557_();
        MobEffectInstance modifiedInstance = effectInstance;
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null);
            if (handler.isEquipped((Item)BrutalityModItems.THE_CLOCK_OF_FROZEN_TIME.get())) {
                if (effect.m_19483_() == MobEffectCategory.HARMFUL) {
                    int duration = (int)((float)originalDuration * 0.65f);
                    duration = Math.max(duration, 1);
                    modifiedInstance = new MobEffectInstance(effect, duration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_());
                } else if (effect.m_19483_() == MobEffectCategory.BENEFICIAL) {
                    int duration = (int)((float)originalDuration * 1.25f);
                    duration = Math.max(duration, 1);
                    modifiedInstance = new MobEffectInstance(effect, duration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_());
                }
            } else if (handler.isEquipped((Item)BrutalityModItems.TIMEKEEPERS_CLOCK.get()) && effect.m_19483_() == MobEffectCategory.HARMFUL) {
                int duration = (int)((float)originalDuration * 0.75f);
                duration = Math.max(duration, 1);
                modifiedInstance = new MobEffectInstance(effect, duration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_());
            }
        }
        if (effect == BrutalityModMobEffects.STUNNED.get() && entity.m_21051_((Attribute)ModAttributes.TENACITY.get()) != null) {
            int duration = (int)((double)originalDuration * (2.0 - entity.m_21133_((Attribute)ModAttributes.TENACITY.get())));
            duration = Math.max(duration, 1);
            modifiedInstance = new MobEffectInstance(effect, duration, effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_());
        }
        return modifiedInstance;
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void alterArmorAbsorb(DamageSource pDamageSource, float pDamageAmount, CallbackInfoReturnable<Float> cir) {
        if (!pDamageSource.m_269533_(DamageTypeTags.f_268490_)) {
            LivingEntity target = (LivingEntity)this;
            Entity attacker = pDamageSource.m_7639_();
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                double lethalityValue = player.m_21133_((Attribute)ModAttributes.LETHALITY.get());
                double armorPenValue = player.m_21133_((Attribute)ModAttributes.ARMOR_PENETRATION.get());
                float modifiedArmor = target.m_21230_();
                modifiedArmor *= (float)(2.0 - armorPenValue);
                float modifiedDamage = CombatRules.m_19272_((float)pDamageAmount, (float)(modifiedArmor -= (float)lethalityValue), (float)((float)target.m_21133_(Attributes.f_22285_)));
                cir.setReturnValue((Object)Float.valueOf(modifiedDamage));
            }
        }
    }

    @ModifyReturnValue(method={"getJumpPower()F"}, at={@At(value="RETURN")})
    private float modifyJumpStrength(float original) {
        LivingEntity livingEntity = (LivingEntity)this;
        AttributeInstance jumpAttr = livingEntity.m_21051_((Attribute)ModAttributes.JUMP_HEIGHT.get());
        if (jumpAttr != null) {
            return (float)((double)original + (jumpAttr.m_22135_() - 1.2522) * 0.159);
        }
        return original;
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleDodge(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (pSource.m_269533_(DamageTypeTags.f_273918_)) {
            return;
        }
        if (livingEntity.m_21023_((MobEffect)BrutalityModMobEffects.DODGE_COOLDOWN.get())) {
            return;
        }
        AttributeInstance dodgeAttr = livingEntity.m_21051_((Attribute)ModAttributes.DODGE_CHANCE.get());
        if (dodgeAttr != null && (double)Mth.m_216267_((RandomSource)livingEntity.m_217043_(), (float)0.0f, (float)1.0f) < dodgeAttr.m_22135_() - 1.0) {
            LivingDodgeEvent.Server dodgeEvent = new LivingDodgeEvent.Server(livingEntity, pSource, pAmount);
            MinecraftForge.EVENT_BUS.post((Event)dodgeEvent);
            if (!dodgeEvent.isCanceled()) {
                Level level = livingEntity.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_5594_(null, livingEntity.m_20097_(), ModUtils.getRandomSound(BrutalityModSounds.DODGE_SOUNDS), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)livingEntity.m_217043_(), (float)0.5f, (float)1.5f));
                }
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.DODGE_COOLDOWN.get(), 10));
                CuriosApi.getCuriosInventory((LivingEntity)livingEntity).ifPresent(itemHandler -> itemHandler.getStacksHandler("anklet").ifPresent(stacksHandler -> {
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                        Item patt8734$temp = stack.m_41720_();
                        if (!(patt8734$temp instanceof BrutalityAnkletItem)) continue;
                        BrutalityAnkletItem ankletItem = (BrutalityAnkletItem)patt8734$temp;
                        try {
                            Method method = ankletItem.getClass().getDeclaredMethod("onDodgeServer", LivingEntity.class, DamageSource.class, Float.TYPE, ItemStack.class);
                            if (method.getDeclaringClass() == BrutalityAnkletItem.class) continue;
                            ankletItem.onDodgeServer(livingEntity, pSource, pAmount, stack);
                            PacketHandler.sendToAllClients(new ClientboundDodgePacket(livingEntity.m_19879_(), pSource, pAmount, stack));
                            continue;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }));
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD")}, cancellable=true)
    private void managePushable(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        ItemStack mainHand = livingEntity.m_21205_();
        ItemStack offhand = livingEntity.m_21206_();
        if (mainHand.m_41720_() instanceof DarkinScythe && ModUtils.getTextureIdx(mainHand) == 1) {
            cir.setReturnValue((Object)false);
        }
        if (offhand.m_41720_() instanceof DarkinScythe && ModUtils.getTextureIdx(offhand) == 1) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getJumpPower"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyJumpPower(CallbackInfoReturnable<Float> cir) {
        int level;
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)BrutalityModMobEffects.SLICKED.get())) {
            level = entity.m_21124_((MobEffect)BrutalityModMobEffects.SLICKED.get()).m_19564_() + 1;
            cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF() * (1.0f - 0.15f * (float)level)));
        }
        if (entity.m_21023_((MobEffect)BrutalityModMobEffects.OILED.get())) {
            level = entity.m_21124_((MobEffect)BrutalityModMobEffects.OILED.get()).m_19564_() + 1;
            cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF() * (1.0f - 0.05f * (float)level)));
        }
    }

    @Override
    public float brutality$getBrutalityRoll() {
        return this.brutality$roll;
    }

    @Override
    public float brutality$getBrutalityPrevRoll() {
        return this.brutality$prevRoll;
    }

    @Override
    public float brutality$getBrutalityYaw() {
        return this.brutality$yaw;
    }

    @Override
    public float brutality$getBrutalityPrevYaw() {
        return this.brutality$prevYaw;
    }

    @Override
    public float brutality$getBrutalityPitch() {
        return this.brutality$pitch;
    }

    @Override
    public float brutality$getBrutalityPrevPitch() {
        return this.brutality$prevPitch;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void calculateAngles(CallbackInfo ci) {
        this.brutality$prevRoll = this.brutality$roll;
        this.brutality$prevYaw = this.brutality$yaw;
        this.brutality$prevPitch = this.brutality$pitch;
        Vec3 motion = this.m_20184_();
        float speed = (float)motion.m_82553_();
        if ((double)speed > 0.1) {
            this.brutality$roll += speed * 30.0f;
            this.brutality$yaw = (float)Math.atan2(motion.f_82481_, motion.f_82479_) * 57.295776f - 90.0f;
            this.brutality$pitch = (float)Math.atan2(motion.f_82480_, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)) * 57.295776f;
        }
    }
}

