/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.goo.brutality.client.player_animation.AnimationHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundPlayerAnimationPacket {
    UUID playerId;
    ResourceLocation animation;
    boolean mirrored;
    float speed;

    public ClientboundPlayerAnimationPacket(UUID playerId, ResourceLocation animation, boolean mirrored, float speed) {
        this.playerId = playerId;
        this.animation = animation;
        this.mirrored = mirrored;
        this.speed = speed;
    }

    public ClientboundPlayerAnimationPacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.animation = buf.m_130281_();
        this.mirrored = buf.readBoolean();
        this.speed = buf.readFloat();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.m_130085_(this.animation);
        buf.writeBoolean(this.mirrored);
        buf.writeFloat(this.speed);
    }

    public static void handle(ClientboundPlayerAnimationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> AnimationHelper.playAnimation(packet.playerId, packet.animation, packet.mirrored, packet.speed));
        ctx.get().setPacketHandled(true);
    }
}

