/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundDamageEntityPacket {
    private final int entityId;
    private final float damage;
    private final ResourceKey<DamageType> damageTypeKey;

    public ServerboundDamageEntityPacket(int entityId, float damage, DamageSource damageSource) {
        this.entityId = entityId;
        this.damage = damage;
        this.damageTypeKey = (ResourceKey)damageSource.m_269150_().m_203543_().orElseThrow(() -> new IllegalArgumentException("Unregistered damage type"));
    }

    public ServerboundDamageEntityPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.damage = buf.readFloat();
        this.damageTypeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)buf.m_130281_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.writeFloat(this.damage);
        buf.m_130085_(this.damageTypeKey.m_135782_());
    }

    public DamageSource createDamageSource(RegistryAccess registryAccess) {
        return new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(this.damageTypeKey));
    }

    public static void handle(ServerboundDamageEntityPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.m_284548_();
            Entity target = level.m_6815_(packet.entityId);
            if (target == null || !target.m_6084_()) {
                return;
            }
            DamageSource source = packet.createDamageSource(level.m_9598_());
            target.m_6469_(source, packet.damage);
        });
        context.setPacketHandled(true);
    }
}

