/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerboundParticlePacket {
    private final double x;
    private final double y;
    private final double z;
    private final double xDelta;
    private final double yDelta;
    private final double zDelta;
    private final ParticleOptions particle;
    private final int count;
    private final float speed;

    public ServerboundParticlePacket(double pX, double pY, double pZ, double xDelta, double yDelta, double zDelta, ParticleOptions particle, int count, float speed) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.xDelta = xDelta;
        this.yDelta = yDelta;
        this.zDelta = zDelta;
        this.particle = particle;
        this.count = count;
        this.speed = speed;
    }

    public ServerboundParticlePacket(FriendlyByteBuf pBuffer) {
        ParticleType<?> type = ServerboundParticlePacket.readParticleType(pBuffer);
        this.x = pBuffer.readDouble();
        this.y = pBuffer.readDouble();
        this.z = pBuffer.readDouble();
        this.xDelta = pBuffer.readDouble();
        this.yDelta = pBuffer.readDouble();
        this.zDelta = pBuffer.readDouble();
        this.particle = this.readParticle(pBuffer, type);
        this.count = pBuffer.readInt();
        this.speed = pBuffer.readFloat();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        ServerboundParticlePacket.writeParticleType(pBuffer, this.particle.m_6012_());
        pBuffer.writeDouble(this.x);
        pBuffer.writeDouble(this.y);
        pBuffer.writeDouble(this.z);
        pBuffer.writeDouble(this.xDelta);
        pBuffer.writeDouble(this.yDelta);
        pBuffer.writeDouble(this.zDelta);
        this.particle.m_7711_(pBuffer);
        pBuffer.writeInt(this.count);
        pBuffer.writeFloat(this.speed);
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf pBuffer, ParticleType<T> pParticleType) {
        return (T)pParticleType.m_123743_().m_6507_(pParticleType, pBuffer);
    }

    private static void writeParticleType(FriendlyByteBuf buf, ParticleType<?> type) {
        buf.m_130085_(Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getKey(type)));
    }

    private static ParticleType<?> readParticleType(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(id);
        if (type != null) {
            return type;
        }
        return ParticleTypes.f_123813_;
    }

    public static void handle(ServerboundParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (sender != null);
            Level patt3194$temp = sender.m_9236_();
            if (patt3194$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt3194$temp;
                serverLevel.m_8767_(packet.particle, packet.x, packet.y, packet.z, packet.count, packet.xDelta, packet.yDelta, packet.zDelta, (double)packet.speed);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

